/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.sourcetarget;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.paths.ShortestPathStreamProc;
import org.neo4j.gds.paths.StreamResult;
import org.neo4j.gds.paths.yens.Yens;
import org.neo4j.gds.paths.yens.YensFactory;
import org.neo4j.gds.paths.yens.config.ShortestPathYensStreamConfig;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.shortestPath.yens.stream", description="The Yen's shortest path algorithm computes the k shortest (weighted) paths between a pair of nodes.", executionMode=ExecutionMode.STREAM)
public class ShortestPathYensStreamProc
extends ShortestPathStreamProc<Yens, ShortestPathYensStreamConfig> {
    @Procedure(name="gds.shortestPath.yens.stream", mode=Mode.READ)
    @Description(value="The Yen's shortest path algorithm computes the k shortest (weighted) paths between a pair of nodes.")
    public Stream<StreamResult> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stream(this.compute(graphName, configuration, false, true));
    }

    @Procedure(name="gds.shortestPath.yens.stream.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected ShortestPathYensStreamConfig newConfig(String username, CypherMapWrapper config) {
        return ShortestPathYensStreamConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<Yens, ShortestPathYensStreamConfig> algorithmFactory() {
        return new YensFactory();
    }
}

