/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.sourcetarget;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.paths.ShortestPathWriteProc;
import org.neo4j.gds.paths.yens.Yens;
import org.neo4j.gds.paths.yens.YensFactory;
import org.neo4j.gds.paths.yens.config.ShortestPathYensWriteConfig;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.results.StandardWriteRelationshipsResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.shortestPath.yens.write", description="The Yen's shortest path algorithm computes the k shortest (weighted) paths between a pair of nodes.", executionMode=ExecutionMode.WRITE_RELATIONSHIP)
public class ShortestPathYensWriteProc
extends ShortestPathWriteProc<Yens, ShortestPathYensWriteConfig> {
    @Procedure(name="gds.shortestPath.yens.write", mode=Mode.WRITE)
    @Description(value="The Yen's shortest path algorithm computes the k shortest (weighted) paths between a pair of nodes.")
    public Stream<StandardWriteRelationshipsResult> write(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.write(this.compute(graphName, configuration, false, true));
    }

    @Procedure(name="gds.shortestPath.yens.write.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected ShortestPathYensWriteConfig newConfig(String username, CypherMapWrapper config) {
        return ShortestPathYensWriteConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<Yens, ShortestPathYensWriteConfig> algorithmFactory() {
        return new YensFactory();
    }
}

