/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.traverse;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.MemoryEstimationExecutor;
import org.neo4j.gds.executor.ProcedureExecutor;
import org.neo4j.gds.paths.MutateResult;
import org.neo4j.gds.paths.traverse.BfsMutateSpec;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class BfsMutateProc
extends BaseProc {
    @Procedure(name="gds.bfs.mutate", mode=Mode.READ)
    @Description(value="BFS is a traversal algorithm, which explores all of the neighbor nodes at the present depth prior to moving on to the nodes at the next depth level.")
    public Stream<MutateResult> mutate(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        BfsMutateSpec mutateSpec = new BfsMutateSpec();
        return (Stream)new ProcedureExecutor((AlgorithmSpec)mutateSpec, this.executionContext()).compute(graphName, configuration, false, false);
    }

    @Procedure(name="gds.bfs.mutate.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        BfsMutateSpec mutateSpec = new BfsMutateSpec();
        return new MemoryEstimationExecutor((AlgorithmSpec)mutateSpec, this.executionContext()).computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }
}

