/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.traverse;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.MemoryEstimationExecutor;
import org.neo4j.gds.executor.ProcedureExecutor;
import org.neo4j.gds.paths.traverse.BFS;
import org.neo4j.gds.paths.traverse.BfsStreamConfig;
import org.neo4j.gds.paths.traverse.BfsStreamResult;
import org.neo4j.gds.paths.traverse.BfsStreamSpec;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class BfsStreamProc
extends AlgoBaseProc<BFS, HugeLongArray, BfsStreamConfig, BfsStreamResult> {
    static final RelationshipType NEXT = RelationshipType.withName((String)"NEXT");
    static final String DESCRIPTION = "BFS is a traversal algorithm, which explores all of the neighbor nodes at the present depth prior to moving on to the nodes at the next depth level.";

    @Procedure(name="gds.bfs.stream", mode=Mode.READ)
    @Description(value="BFS is a traversal algorithm, which explores all of the neighbor nodes at the present depth prior to moving on to the nodes at the next depth level.")
    public Stream<BfsStreamResult> bfs(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        BfsStreamSpec streamSpec = new BfsStreamSpec();
        return (Stream)new ProcedureExecutor((AlgorithmSpec)streamSpec, this.executionContext()).compute(graphName, configuration, true, true);
    }

    @Procedure(name="gds.bfs.stream.estimate", mode=Mode.READ)
    @Description(value="BFS is a traversal algorithm, which explores all of the neighbor nodes at the present depth prior to moving on to the nodes at the next depth level.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphName") Object graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        BfsStreamSpec streamSpec = new BfsStreamSpec();
        return new MemoryEstimationExecutor((AlgorithmSpec)streamSpec, this.executionContext()).computeEstimate(graphName, configuration);
    }

    public GraphAlgorithmFactory<BFS, BfsStreamConfig> algorithmFactory() {
        return new BfsStreamSpec().algorithmFactory();
    }

    protected BfsStreamConfig newConfig(String username, CypherMapWrapper config) {
        return (BfsStreamConfig)new BfsStreamSpec().newConfigFunction().apply(username, config);
    }

    public ComputationResultConsumer<BFS, HugeLongArray, BfsStreamConfig, Stream<BfsStreamResult>> computationResultConsumer() {
        return new BfsStreamSpec().computationResultConsumer();
    }
}

