/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.traverse;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.MemoryEstimationExecutor;
import org.neo4j.gds.executor.ProcedureExecutor;
import org.neo4j.gds.paths.MutateResult;
import org.neo4j.gds.paths.traverse.DfsMutateSpec;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class DfsMutateProc
extends BaseProc {
    @Procedure(name="gds.dfs.mutate", mode=Mode.READ)
    @Description(value="Depth-first search (DFS) is an algorithm for traversing or searching tree or graph data structures. The algorithm starts at the root node (selecting some arbitrary node as the root node in the case of a graph) and explores as far as possible along each branch before backtracking.")
    public Stream<MutateResult> mutate(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        DfsMutateSpec mutateSpec = new DfsMutateSpec();
        return (Stream)new ProcedureExecutor((AlgorithmSpec)mutateSpec, this.executionContext()).compute(graphName, configuration, false, false);
    }

    @Procedure(name="gds.dfs.mutate.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        DfsMutateSpec mutateSpec = new DfsMutateSpec();
        return new MemoryEstimationExecutor((AlgorithmSpec)mutateSpec, this.executionContext()).computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }
}

