/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.traverse;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.MemoryEstimationExecutor;
import org.neo4j.gds.executor.ProcedureExecutor;
import org.neo4j.gds.paths.traverse.DFS;
import org.neo4j.gds.paths.traverse.DfsStreamConfig;
import org.neo4j.gds.paths.traverse.DfsStreamResult;
import org.neo4j.gds.paths.traverse.DfsStreamSpec;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class DfsStreamProc
extends AlgoBaseProc<DFS, HugeLongArray, DfsStreamConfig, DfsStreamResult> {
    static final RelationshipType NEXT = RelationshipType.withName((String)"NEXT");
    static final String DESCRIPTION = "Depth-first search (DFS) is an algorithm for traversing or searching tree or graph data structures. The algorithm starts at the root node (selecting some arbitrary node as the root node in the case of a graph) and explores as far as possible along each branch before backtracking.";

    @Procedure(name="gds.dfs.stream", mode=Mode.READ)
    @Description(value="Depth-first search (DFS) is an algorithm for traversing or searching tree or graph data structures. The algorithm starts at the root node (selecting some arbitrary node as the root node in the case of a graph) and explores as far as possible along each branch before backtracking.")
    public Stream<DfsStreamResult> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        DfsStreamSpec streamSpec = new DfsStreamSpec();
        return (Stream)new ProcedureExecutor((AlgorithmSpec)streamSpec, this.executionContext()).compute(graphName, configuration, true, true);
    }

    @Procedure(name="gds.dfs.stream.estimate", mode=Mode.READ)
    @Description(value="Depth-first search (DFS) is an algorithm for traversing or searching tree or graph data structures. The algorithm starts at the root node (selecting some arbitrary node as the root node in the case of a graph) and explores as far as possible along each branch before backtracking.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphName") Object graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        DfsStreamSpec streamSpec = new DfsStreamSpec();
        return new MemoryEstimationExecutor((AlgorithmSpec)streamSpec, this.executionContext()).computeEstimate(graphName, configuration);
    }

    public GraphAlgorithmFactory<DFS, DfsStreamConfig> algorithmFactory() {
        return new DfsStreamSpec().algorithmFactory();
    }

    protected DfsStreamConfig newConfig(String username, CypherMapWrapper config) {
        return (DfsStreamConfig)new DfsStreamSpec().newConfigFunction().apply(username, config);
    }

    public ComputationResultConsumer<DFS, HugeLongArray, DfsStreamConfig, Stream<DfsStreamResult>> computationResultConsumer() {
        return new DfsStreamSpec().computationResultConsumer();
    }
}

