/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.traverse;

import java.util.stream.Stream;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.paths.traverse.DFS;
import org.neo4j.gds.paths.traverse.DfsAlgorithmFactory;
import org.neo4j.gds.paths.traverse.DfsStreamComputationResultConsumer;
import org.neo4j.gds.paths.traverse.DfsStreamConfig;
import org.neo4j.gds.paths.traverse.DfsStreamResult;
import org.neo4j.gds.paths.traverse.PathFactoryFacade;

@GdsCallable(name="gds.dfs.stream", description="Depth-first search (DFS) is an algorithm for traversing or searching tree or graph data structures. The algorithm starts at the root node (selecting some arbitrary node as the root node in the case of a graph) and explores as far as possible along each branch before backtracking.", executionMode=ExecutionMode.STREAM)
public class DfsStreamSpec
implements AlgorithmSpec<DFS, HugeLongArray, DfsStreamConfig, Stream<DfsStreamResult>, DfsAlgorithmFactory<DfsStreamConfig>> {
    public String name() {
        return "DfsStream";
    }

    public DfsAlgorithmFactory<DfsStreamConfig> algorithmFactory() {
        return new DfsAlgorithmFactory();
    }

    public NewConfigFunction<DfsStreamConfig> newConfigFunction() {
        return (__, config) -> DfsStreamConfig.of((CypherMapWrapper)config);
    }

    public ComputationResultConsumer<DFS, HugeLongArray, DfsStreamConfig, Stream<DfsStreamResult>> computationResultConsumer() {
        return new DfsStreamComputationResultConsumer(new PathFactoryFacade());
    }
}

