/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.traverse;

import java.util.Optional;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.PartialIdMap;
import org.neo4j.gds.api.Relationships;
import org.neo4j.gds.core.loading.construction.GraphFactory;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilder;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.result.AbstractResultBuilder;

final class TraverseMutateResultConsumer {
    private TraverseMutateResultConsumer() {
    }

    static void updateGraphStore(Graph graph, AbstractResultBuilder<?> resultBuilder, HugeLongArray result, String relationshipType, GraphStore graphStore) {
        Relationships relationships;
        RelationshipType mutateRelationshipType = RelationshipType.of((String)relationshipType);
        RelationshipsBuilder relationshipsBuilder = GraphFactory.initRelationshipsBuilder().nodes((PartialIdMap)graph).orientation(Orientation.NATURAL).build();
        try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> resultBuilder.withMutateMillis(arg_0));){
            long source = result.get(0L);
            for (long i = 1L; i < result.size(); ++i) {
                long target = result.get(i);
                relationshipsBuilder.addFromInternal(source, target);
                source = target;
            }
            relationships = relationshipsBuilder.build();
            resultBuilder.withRelationshipsWritten(relationships.topology().elementCount());
        }
        graphStore.addRelationshipType(mutateRelationshipType, Optional.empty(), Optional.empty(), relationships);
    }
}

