/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.paths.traverse;

import java.util.Arrays;
import java.util.List;
import java.util.function.LongUnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.paths.traverse.PathFactoryFacade;
import org.neo4j.graphdb.Path;
import org.neo4j.graphdb.RelationshipType;
import org.neo4j.graphdb.Transaction;

final class TraverseStreamComputationResultConsumer {
    private TraverseStreamComputationResultConsumer() {
    }

    static <T> Stream<T> consume(long sourceNodeId, @Nullable HugeLongArray nodes, LongUnaryOperator toOriginalNodeId, boolean graphIsEmpty, ConcreteResultTransformer<T> resultTransformer, boolean shouldReturnPath, PathFactoryFacade pathFactoryFacade, RelationshipType relationshipType, Transaction internalTransaction) {
        if (graphIsEmpty || null == nodes) {
            return Stream.empty();
        }
        long[] nodesArray = nodes.toArray();
        List<Long> nodeList = Arrays.stream(nodesArray).boxed().map(toOriginalNodeId::applyAsLong).collect(Collectors.toList());
        Path path = null;
        if (shouldReturnPath) {
            path = pathFactoryFacade.createPath(internalTransaction, nodeList, relationshipType);
        }
        return Stream.of(resultTransformer.transform(sourceNodeId, nodeList, path));
    }

    @FunctionalInterface
    static interface ConcreteResultTransformer<T> {
        public T transform(long var1, @Nullable List<Long> var3, @Nullable Path var4);
    }
}

