/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pipeline.catalog;

import java.util.stream.Stream;
import org.neo4j.gds.ml.pipeline.PipelineCatalog;
import org.neo4j.gds.ml.pipeline.TrainingPipeline;
import org.neo4j.gds.pipeline.catalog.PipelineCatalogProc;
import org.neo4j.gds.pipeline.catalog.PipelineCatalogResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class PipelineDropProc
extends PipelineCatalogProc {
    private static final String DESCRIPTION = "Drops a pipeline and frees up the resources it occupies.";

    @Procedure(name="gds.beta.pipeline.drop", mode=Mode.READ)
    @Description(value="Drops a pipeline and frees up the resources it occupies.")
    public Stream<PipelineCatalogResult> drop(@Name(value="pipelineName") String pipelineName, @Name(value="failIfMissing", defaultValue="true") boolean failIfMissing) {
        this.validatePipelineName(pipelineName);
        TrainingPipeline pipeline = null;
        if (failIfMissing) {
            pipeline = PipelineCatalog.drop((String)this.username(), (String)pipelineName);
        } else if (PipelineCatalog.exists((String)this.username(), (String)pipelineName)) {
            pipeline = PipelineCatalog.drop((String)this.username(), (String)pipelineName);
        }
        return Stream.ofNullable(pipeline).map(pipe -> new PipelineCatalogResult((TrainingPipeline<?>)pipe, pipelineName));
    }
}

