/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pipeline.catalog;

import java.util.stream.Stream;
import org.neo4j.gds.ml.pipeline.PipelineCatalog;
import org.neo4j.gds.pipeline.catalog.PipelineCatalogProc;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class PipelineExistsProc
extends PipelineCatalogProc {
    private static final String DESCRIPTION = "Checks if a given pipeline exists in the pipeline catalog.";

    @Procedure(name="gds.beta.pipeline.exists", mode=Mode.READ)
    @Description(value="Checks if a given pipeline exists in the pipeline catalog.")
    public Stream<PipelineExistsResult> exists(@Name(value="pipelineName") String pipelineName) {
        String type;
        boolean exists;
        this.validatePipelineName(pipelineName);
        if (PipelineCatalog.exists((String)this.username(), (String)pipelineName)) {
            exists = true;
            type = PipelineCatalog.get((String)this.username(), (String)pipelineName).type();
        } else {
            exists = false;
            type = "n/a";
        }
        return Stream.of(new PipelineExistsResult(pipelineName, type, exists));
    }

    public static class PipelineExistsResult {
        public final String pipelineName;
        public final String pipelineType;
        public final boolean exists;

        PipelineExistsResult(String pipelineName, String pipelineType, boolean exists) {
            this.pipelineName = pipelineName;
            this.pipelineType = pipelineType;
            this.exists = exists;
        }
    }
}

