/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pipeline.catalog;

import java.util.stream.Stream;
import org.neo4j.gds.ml.pipeline.PipelineCatalog;
import org.neo4j.gds.ml.pipeline.TrainingPipeline;
import org.neo4j.gds.pipeline.catalog.PipelineCatalogProc;
import org.neo4j.gds.pipeline.catalog.PipelineCatalogResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class PipelineListProc
extends PipelineCatalogProc {
    private static final String DESCRIPTION = "Lists all pipelines contained in the pipeline catalog.";

    @Procedure(name="gds.beta.pipeline.list", mode=Mode.READ)
    @Description(value="Lists all pipelines contained in the pipeline catalog.")
    public Stream<PipelineCatalogResult> list(@Name(value="pipelineName", defaultValue="__NO_VALUE") String pipelineName) {
        if (pipelineName == null || pipelineName.equals("__NO_VALUE")) {
            Stream pipelines = PipelineCatalog.getAllPipelines((String)this.username());
            return pipelines.map(pipe -> new PipelineCatalogResult(pipe.pipeline(), pipe.pipelineName()));
        }
        this.validatePipelineName(pipelineName);
        if (PipelineCatalog.exists((String)this.username(), (String)pipelineName)) {
            TrainingPipeline pipeline = PipelineCatalog.get((String)this.username(), (String)pipelineName);
            return Stream.of(new PipelineCatalogResult(pipeline, pipelineName));
        }
        return Stream.empty();
    }
}

