/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pregel.proc;

import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.api.NodeProperties;
import org.neo4j.gds.api.nodeproperties.DoubleArrayNodeProperties;
import org.neo4j.gds.api.nodeproperties.LongArrayNodeProperties;
import org.neo4j.gds.beta.pregel.NodeValue;
import org.neo4j.gds.beta.pregel.PregelConfig;
import org.neo4j.gds.beta.pregel.PregelResult;
import org.neo4j.gds.beta.pregel.PregelSchema;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.core.write.ImmutableNodeProperty;
import org.neo4j.gds.core.write.NodeProperty;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.utils.StringFormatting;

final class PregelBaseProc {
    static <ALGO extends Algorithm<PregelResult>, CONFIG extends PregelConfig> List<NodeProperty> nodeProperties(ComputationResult<ALGO, PregelResult, CONFIG> computationResult, String propertyPrefix) {
        NodeValue compositeNodeValue = ((PregelResult)computationResult.result()).nodeValues();
        PregelSchema schema = compositeNodeValue.schema();
        return schema.elements().stream().filter(element -> element.visibility() == PregelSchema.Visibility.PUBLIC).map(element -> {
            Object nodeProperties;
            String propertyKey = element.propertyKey();
            switch (element.propertyType()) {
                case LONG: {
                    nodeProperties = compositeNodeValue.longProperties(propertyKey).asNodeProperties();
                    break;
                }
                case DOUBLE: {
                    nodeProperties = compositeNodeValue.doubleProperties(propertyKey).asNodeProperties();
                    break;
                }
                case LONG_ARRAY: {
                    nodeProperties = new HugeObjectArrayLongArrayProperties((HugeObjectArray<long[]>)compositeNodeValue.longArrayProperties(propertyKey));
                    break;
                }
                case DOUBLE_ARRAY: {
                    nodeProperties = new HugeObjectArrayDoubleArrayProperties((HugeObjectArray<double[]>)compositeNodeValue.doubleArrayProperties(propertyKey));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported property type: " + element.propertyType());
                }
            }
            return ImmutableNodeProperty.of((String)StringFormatting.formatWithLocale((String)"%s%s", (Object[])new Object[]{propertyPrefix, propertyKey}), (NodeProperties)nodeProperties);
        }).collect(Collectors.toList());
    }

    private PregelBaseProc() {
    }

    static class HugeObjectArrayDoubleArrayProperties
    implements DoubleArrayNodeProperties {
        private final HugeObjectArray<double[]> doubleArrays;

        HugeObjectArrayDoubleArrayProperties(HugeObjectArray<double[]> doubleArrays) {
            this.doubleArrays = doubleArrays;
        }

        public long size() {
            return this.doubleArrays.size();
        }

        public double[] doubleArrayValue(long nodeId) {
            return (double[])this.doubleArrays.get(nodeId);
        }
    }

    static class HugeObjectArrayLongArrayProperties
    implements LongArrayNodeProperties {
        private final HugeObjectArray<long[]> longArrays;

        HugeObjectArrayLongArrayProperties(HugeObjectArray<long[]> longArrays) {
            this.longArrays = longArrays;
        }

        public long size() {
            return this.longArrays.size();
        }

        public long[] longArrayValue(long nodeId) {
            return (long[])this.longArrays.get(nodeId);
        }
    }
}

