/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pregel.proc;

import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.ElementIdentifier;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.properties.nodes.DoubleArrayNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.LongArrayNodePropertyValues;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.api.schema.RelationshipSchema;
import org.neo4j.gds.beta.indexInverse.InverseRelationships;
import org.neo4j.gds.beta.indexInverse.InverseRelationshipsAlgorithmFactory;
import org.neo4j.gds.beta.indexInverse.InverseRelationshipsConfig;
import org.neo4j.gds.beta.indexInverse.InverseRelationshipsConfigImpl;
import org.neo4j.gds.beta.pregel.NodeValue;
import org.neo4j.gds.beta.pregel.PregelConfig;
import org.neo4j.gds.beta.pregel.PregelResult;
import org.neo4j.gds.beta.pregel.PregelSchema;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.core.utils.paged.HugeObjectArray;
import org.neo4j.gds.core.utils.progress.TaskRegistryFactory;
import org.neo4j.gds.core.write.ImmutableNodeProperty;
import org.neo4j.gds.core.write.NodeProperty;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.validation.AfterLoadValidation;
import org.neo4j.gds.executor.validation.ValidationConfiguration;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;
import org.neo4j.logging.Log;

public final class PregelBaseProc {
    public static <CONFIG extends PregelConfig> ValidationConfiguration<CONFIG> ensureIndexValidation(final Log log, final TaskRegistryFactory taskRegistryFactory) {
        return new ValidationConfiguration<CONFIG>(){

            public List<AfterLoadValidation<CONFIG>> afterLoadValidations() {
                return List.of((graphStore, graphProjectConfig, config) -> PregelBaseProc.ensureDirectedRelationships(graphStore, config.internalRelationshipTypes(graphStore)), (graphStore, graphProjectConfig, config) -> PregelBaseProc.ensureInverseIndexesExist(graphStore, config.internalRelationshipTypes(graphStore), config.concurrency(), log, taskRegistryFactory));
            }
        };
    }

    static void ensureInverseIndexesExist(GraphStore graphStore, Collection<RelationshipType> relationshipTypes, int concurrency, Log log, TaskRegistryFactory taskRegistryFactory) {
        List relationshipTypesWithoutIndex = relationshipTypes.stream().filter(relType -> !graphStore.inverseIndexedRelationshipTypes().contains(relType)).map(ElementIdentifier::name).collect(Collectors.toList());
        if (relationshipTypesWithoutIndex.isEmpty()) {
            return;
        }
        InverseRelationshipsConfig inverseConfig = InverseRelationshipsConfigImpl.builder().concurrency(concurrency).relationshipTypes(relationshipTypesWithoutIndex).build();
        ((InverseRelationships)new InverseRelationshipsAlgorithmFactory().build((Object)graphStore, (AlgoBaseConfig)inverseConfig, log, taskRegistryFactory)).compute().forEach((relationshipType, inverseIndex) -> graphStore.addInverseIndex(relationshipType, inverseIndex.topology(), inverseIndex.properties()));
    }

    static void ensureDirectedRelationships(GraphStore graphStore, Collection<RelationshipType> relationshipTypes) {
        RelationshipSchema relationshipSchema = graphStore.schema().relationshipSchema();
        List undirectedTypes = relationshipTypes.stream().filter(arg_0 -> ((RelationshipSchema)relationshipSchema).isUndirected(arg_0)).map(ElementIdentifier::name).collect(Collectors.toList());
        if (!undirectedTypes.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.US, "This algorithm requires a directed graph, but the following configured relationship types are undirected: %s.", StringJoining.join(undirectedTypes)));
        }
    }

    static <ALGO extends Algorithm<PregelResult>, CONFIG extends PregelConfig> List<NodeProperty> nodeProperties(ComputationResult<ALGO, PregelResult, CONFIG> computationResult, String propertyPrefix) {
        NodeValue compositeNodeValue = ((PregelResult)computationResult.result()).nodeValues();
        PregelSchema schema = compositeNodeValue.schema();
        return schema.elements().stream().filter(element -> element.visibility() == PregelSchema.Visibility.PUBLIC).map(element -> {
            Object nodePropertyValues;
            String propertyKey = element.propertyKey();
            switch (element.propertyType()) {
                case LONG: {
                    nodePropertyValues = compositeNodeValue.longProperties(propertyKey).asNodeProperties();
                    break;
                }
                case DOUBLE: {
                    nodePropertyValues = compositeNodeValue.doubleProperties(propertyKey).asNodeProperties();
                    break;
                }
                case LONG_ARRAY: {
                    nodePropertyValues = new HugeObjectArrayLongArrayPropertyValues((HugeObjectArray<long[]>)compositeNodeValue.longArrayProperties(propertyKey));
                    break;
                }
                case DOUBLE_ARRAY: {
                    nodePropertyValues = new HugeObjectArrayDoubleArrayPropertyValues((HugeObjectArray<double[]>)compositeNodeValue.doubleArrayProperties(propertyKey));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported property type: " + element.propertyType());
                }
            }
            return ImmutableNodeProperty.of((String)StringFormatting.formatWithLocale((String)"%s%s", (Object[])new Object[]{propertyPrefix, propertyKey}), (NodePropertyValues)nodePropertyValues);
        }).collect(Collectors.toList());
    }

    private PregelBaseProc() {
    }

    static class HugeObjectArrayDoubleArrayPropertyValues
    implements DoubleArrayNodePropertyValues {
        private final HugeObjectArray<double[]> doubleArrays;

        HugeObjectArrayDoubleArrayPropertyValues(HugeObjectArray<double[]> doubleArrays) {
            this.doubleArrays = doubleArrays;
        }

        public long nodeCount() {
            return this.doubleArrays.size();
        }

        public double[] doubleArrayValue(long nodeId) {
            return (double[])this.doubleArrays.get(nodeId);
        }
    }

    static class HugeObjectArrayLongArrayPropertyValues
    implements LongArrayNodePropertyValues {
        private final HugeObjectArray<long[]> longArrays;

        HugeObjectArrayLongArrayPropertyValues(HugeObjectArray<long[]> longArrays) {
            this.longArrays = longArrays;
        }

        public long nodeCount() {
            return this.longArrays.size();
        }

        public long[] longArrayValue(long nodeId) {
            return (long[])this.longArrays.get(nodeId);
        }
    }
}

