/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.pregel.proc;

import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.StreamProc;
import org.neo4j.gds.beta.pregel.Element;
import org.neo4j.gds.beta.pregel.NodeValue;
import org.neo4j.gds.beta.pregel.PregelProcedureConfig;
import org.neo4j.gds.beta.pregel.PregelResult;
import org.neo4j.gds.beta.pregel.PregelSchema;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.pregel.proc.PregelStreamResult;

public abstract class PregelStreamProc<ALGO extends Algorithm<PregelResult>, CONFIG extends PregelProcedureConfig>
extends StreamProc<ALGO, PregelResult, PregelStreamResult, CONFIG> {
    protected Stream<PregelStreamResult> stream(ComputationResult<ALGO, PregelResult, CONFIG> computationResult) {
        if (computationResult.isGraphEmpty()) {
            return Stream.empty();
        }
        NodeValue result = ((PregelResult)computationResult.result()).nodeValues();
        return LongStream.range(0L, computationResult.graph().nodeCount()).mapToObj(nodeId -> {
            Map<String, Object> values = result.schema().elements().stream().filter(element -> element.visibility() == PregelSchema.Visibility.PUBLIC).collect(Collectors.toMap(Element::propertyKey, element -> {
                switch (element.propertyType()) {
                    case LONG: {
                        return result.longProperties(element.propertyKey()).get(nodeId);
                    }
                    case DOUBLE: {
                        return result.doubleProperties(element.propertyKey()).get(nodeId);
                    }
                    case DOUBLE_ARRAY: {
                        return result.doubleArrayProperties(element.propertyKey()).get(nodeId);
                    }
                    case LONG_ARRAY: {
                        return result.longArrayProperties(element.propertyKey()).get(nodeId);
                    }
                }
                throw new IllegalArgumentException("Unsupported property type: " + element.propertyType());
            }));
            return new PregelStreamResult(computationResult.graph().toOriginalNodeId(nodeId), values);
        });
    }
}

