/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity;

import java.util.stream.Stream;
import org.HdrHistogram.DoubleHistogram;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.WriteRelationshipsProc;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.WritePropertyConfig;
import org.neo4j.gds.config.WriteRelationshipConfig;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.TaskProgressTracker;
import org.neo4j.gds.core.write.RelationshipExporter;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.similarity.SimilarityGraphResult;
import org.neo4j.gds.similarity.SimilarityProc;
import org.neo4j.gds.similarity.SimilarityWriteResult;

public abstract class SimilarityWriteProc<ALGO extends Algorithm<ALGO_RESULT>, ALGO_RESULT, PROC_RESULT extends SimilarityWriteResult, CONFIG extends WritePropertyConfig & WriteRelationshipConfig>
extends WriteRelationshipsProc<ALGO, ALGO_RESULT, PROC_RESULT, CONFIG> {
    public abstract String procedureName();

    protected abstract SimilarityProc.SimilarityResultBuilder<PROC_RESULT> resultBuilder(ComputationResult<ALGO, ALGO_RESULT, CONFIG> var1);

    protected Stream<PROC_RESULT> write(ComputationResult<ALGO, ALGO_RESULT, CONFIG> computationResult) {
        return (Stream)this.computationResultConsumer().consume(computationResult, this.executionContext());
    }

    public ComputationResultConsumer<ALGO, ALGO_RESULT, CONFIG, Stream<PROC_RESULT>> computationResultConsumer() {
        return (computationResult, executionContext) -> (Stream)this.runWithExceptionLogging("Graph write failed", () -> {
            WritePropertyConfig config = (WritePropertyConfig)computationResult.config();
            if (computationResult.isGraphEmpty()) {
                return Stream.of((SimilarityWriteResult)this.resultBuilder(computationResult).withConfig((AlgoBaseConfig)config).build());
            }
            Algorithm algorithm = computationResult.algorithm();
            SimilarityGraphResult similarityGraphResult = this.similarityGraphResult(computationResult);
            Graph similarityGraph = similarityGraphResult.similarityGraph();
            Graph rootIdMap = similarityGraphResult.isTopKGraph() ? similarityGraph : computationResult.graphStore().nodes();
            SimilarityProc.SimilarityResultBuilder<PROC_RESULT> resultBuilder = this.resultBuilder(computationResult);
            SimilarityProc.withGraphsizeAndTimings(resultBuilder, computationResult, ignore -> similarityGraphResult);
            if (similarityGraph.relationshipCount() > 0L) {
                String writeRelationshipType = ((WriteRelationshipConfig)config).writeRelationshipType();
                String writeProperty = config.writeProperty();
                this.runWithExceptionLogging(this.procedureName() + " write-back failed", () -> this.lambda$computationResultConsumer$2(resultBuilder, similarityGraph, (IdMap)rootIdMap, algorithm, writeRelationshipType, writeProperty));
            }
            return Stream.of((SimilarityWriteResult)resultBuilder.build());
        });
    }

    protected abstract SimilarityGraphResult similarityGraphResult(ComputationResult<ALGO, ALGO_RESULT, CONFIG> var1);

    private /* synthetic */ void lambda$computationResultConsumer$2(SimilarityProc.SimilarityResultBuilder resultBuilder, Graph similarityGraph, IdMap rootIdMap, Algorithm algorithm, String writeRelationshipType, String writeProperty) {
        try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> ((SimilarityProc.SimilarityResultBuilder)resultBuilder).withWriteMillis(arg_0));){
            TaskProgressTracker progressTracker = new TaskProgressTracker(RelationshipExporter.baseTask((String)this.name(), (long)similarityGraph.relationshipCount()), this.executionContext().log(), 1, this.executionContext().taskRegistryFactory());
            RelationshipExporter exporter = this.relationshipExporterBuilder.withIdMappingOperator(arg_0 -> ((IdMap)rootIdMap).toOriginalNodeId(arg_0)).withGraph(similarityGraph).withTerminationFlag(algorithm.getTerminationFlag()).withProgressTracker((ProgressTracker)progressTracker).build();
            if (SimilarityProc.shouldComputeHistogram(this.executionContext().callContext())) {
                DoubleHistogram histogram = new DoubleHistogram(5);
                exporter.write(writeRelationshipType, writeProperty, (node1, node2, similarity) -> {
                    histogram.recordValue(similarity);
                    return true;
                });
                resultBuilder.withHistogram(histogram);
            } else {
                exporter.write(writeRelationshipType, writeProperty);
            }
        }
    }
}

