/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.filteredknn;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.Topology;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.schema.Direction;
import org.neo4j.gds.api.schema.RelationshipPropertySchema;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.huge.HugeGraph;
import org.neo4j.gds.core.loading.SingleTypeRelationships;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.similarity.SimilarityGraphResult;
import org.neo4j.gds.similarity.SimilarityProc;
import org.neo4j.gds.similarity.filteredknn.FilteredKnn;
import org.neo4j.gds.similarity.filteredknn.FilteredKnnFactory;
import org.neo4j.gds.similarity.filteredknn.FilteredKnnHelpers;
import org.neo4j.gds.similarity.filteredknn.FilteredKnnMutateConfig;
import org.neo4j.gds.similarity.filteredknn.FilteredKnnMutateProcResult;
import org.neo4j.gds.similarity.filteredknn.FilteredKnnResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.knn.filtered.mutate", executionMode=ExecutionMode.MUTATE_RELATIONSHIP)
public class FilteredKnnMutateProc
extends AlgoBaseProc<FilteredKnn, FilteredKnnResult, FilteredKnnMutateConfig, FilteredKnnMutateProcResult> {
    @Procedure(name="gds.alpha.knn.filtered.mutate", mode=Mode.READ)
    @Description(value="The k-nearest neighbor graph algorithm constructs relationships between nodes if the distance between two nodes is among the k nearest distances compared to other nodes. KNN computes distances based on the similarity of node properties. Filtered KNN extends this functionality, allowing filtering on source nodes and target nodes, respectively.")
    public Stream<FilteredKnnMutateProcResult> mutate(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return (Stream)this.computationResultConsumer().consume(computationResult, this.executionContext());
    }

    protected FilteredKnnMutateConfig newConfig(String username, CypherMapWrapper config) {
        return FilteredKnnMutateConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<FilteredKnn, FilteredKnnMutateConfig> algorithmFactory() {
        return new FilteredKnnFactory();
    }

    public ComputationResultConsumer<FilteredKnn, FilteredKnnResult, FilteredKnnMutateConfig, Stream<FilteredKnnMutateProcResult>> computationResultConsumer() {
        return (computationResult, executionContext) -> (Stream)this.runWithExceptionLogging("Graph mutation failed", () -> {
            SimilarityGraphResult similarityGraphResult;
            FilteredKnnMutateConfig config = (FilteredKnnMutateConfig)computationResult.config();
            FilteredKnnResult result = (FilteredKnnResult)computationResult.result();
            if (computationResult.isGraphEmpty()) {
                return Stream.of(new FilteredKnnMutateProcResult(computationResult.preProcessingMillis(), 0L, 0L, 0L, 0L, 0L, Collections.emptyMap(), true, 0L, 0L, config.toMap()));
            }
            FilteredKnn algorithm = Objects.requireNonNull((FilteredKnn)computationResult.algorithm());
            AtomicLong mutateMillis = new AtomicLong();
            try (ProgressTimer ignored = ProgressTimer.start(mutateMillis::addAndGet);){
                similarityGraphResult = FilteredKnnHelpers.computeToGraph(computationResult.graph(), algorithm.nodeCount(), config.concurrency(), Objects.requireNonNull(result), algorithm.executorService());
            }
            FilteredKnnMutateProcResult.Builder resultBuilder = new FilteredKnnMutateProcResult.Builder().ranIterations(result.ranIterations()).didConverge(result.didConverge()).withNodePairsConsidered(result.nodePairsConsidered());
            SimilarityProc.withGraphsizeAndTimings(resultBuilder, computationResult, ignore -> similarityGraphResult);
            try (ProgressTimer ignored = ProgressTimer.start(mutateMillis::addAndGet);){
                HugeGraph similarityGraph = (HugeGraph)similarityGraphResult.similarityGraph();
                this.computeHistogram((Graph)similarityGraph, resultBuilder);
                RelationshipType relationshipType = RelationshipType.of((String)config.mutateRelationshipType());
                computationResult.graphStore().addRelationshipType(SingleTypeRelationships.of((RelationshipType)relationshipType, (Topology)similarityGraph.relationshipTopology(), (Direction)similarityGraphResult.direction(), (Optional)similarityGraph.relationshipProperties(), Optional.of(RelationshipPropertySchema.of((String)config.mutateProperty(), (ValueType)ValueType.DOUBLE))));
            }
            resultBuilder.withMutateMillis(mutateMillis.get());
            return Stream.of(resultBuilder.build());
        });
    }

    private void computeHistogram(Graph similarityGraph, FilteredKnnMutateProcResult.Builder resultBuilder) {
        if (SimilarityProc.shouldComputeHistogram(this.callContext)) {
            resultBuilder.withHistogram(SimilarityProc.computeHistogram(similarityGraph));
        }
    }
}

