/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.filteredknn;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.StatsProc;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.similarity.SimilarityGraphResult;
import org.neo4j.gds.similarity.SimilarityProc;
import org.neo4j.gds.similarity.filteredknn.FilteredKnn;
import org.neo4j.gds.similarity.filteredknn.FilteredKnnFactory;
import org.neo4j.gds.similarity.filteredknn.FilteredKnnHelpers;
import org.neo4j.gds.similarity.filteredknn.FilteredKnnResult;
import org.neo4j.gds.similarity.filteredknn.FilteredKnnStatsConfig;
import org.neo4j.gds.similarity.filteredknn.FilteredKnnStatsResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.knn.filtered.stats", executionMode=ExecutionMode.STATS)
public final class FilteredKnnStatsProc
extends StatsProc<FilteredKnn, FilteredKnnResult, FilteredKnnStatsResult, FilteredKnnStatsConfig> {
    @Procedure(name="gds.alpha.knn.filtered.stats", mode=Mode.READ)
    @Description(value="Executes the algorithm and returns result statistics without writing the result to Neo4j.")
    public Stream<FilteredKnnStatsResult> stats(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stats((ComputationResult<FilteredKnn, FilteredKnnResult, FilteredKnnStatsConfig>)this.compute(graphName, configuration));
    }

    protected FilteredKnnStatsConfig newConfig(String username, CypherMapWrapper config) {
        return FilteredKnnStatsConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<FilteredKnn, FilteredKnnStatsConfig> algorithmFactory() {
        return new FilteredKnnFactory();
    }

    protected AbstractResultBuilder<FilteredKnnStatsResult> resultBuilder(ComputationResult<FilteredKnn, FilteredKnnResult, FilteredKnnStatsConfig> computeResult, ExecutionContext executionContext) {
        throw new UnsupportedOperationException("Knn handles result building individually.");
    }

    public Stream<FilteredKnnStatsResult> stats(ComputationResult<FilteredKnn, FilteredKnnResult, FilteredKnnStatsConfig> computationResult) {
        return (Stream)this.runWithExceptionLogging("Graph stats failed", () -> {
            FilteredKnnStatsConfig config = (FilteredKnnStatsConfig)computationResult.config();
            if (computationResult.isGraphEmpty()) {
                return Stream.of(new FilteredKnnStatsResult(computationResult.preProcessingMillis(), 0L, 0L, 0L, 0L, Collections.emptyMap(), true, 0L, 0L, config.toMap()));
            }
            FilteredKnn algorithm = Objects.requireNonNull((FilteredKnn)computationResult.algorithm());
            FilteredKnnResult result = Objects.requireNonNull((FilteredKnnResult)computationResult.result());
            FilteredKnnStatsResult.Builder resultBuilder = new FilteredKnnStatsResult.Builder().withRanIterations(result.ranIterations()).withNodePairsConsidered(result.nodePairsConsidered()).withDidConverge(result.didConverge());
            SimilarityProc.resultBuilderWithTimings(resultBuilder, computationResult);
            if (SimilarityProc.shouldComputeHistogram(this.callContext)) {
                try (ProgressTimer ignored = resultBuilder.timePostProcessing();){
                    SimilarityGraphResult similarityGraphResult = FilteredKnnHelpers.computeToGraph(computationResult.graph(), algorithm.nodeCount(), config.concurrency(), result, algorithm.executorService());
                    Graph similarityGraph = similarityGraphResult.similarityGraph();
                    resultBuilder.withHistogram(SimilarityProc.computeHistogram(similarityGraph)).withNodesCompared(similarityGraphResult.comparedNodes()).withRelationshipsWritten(similarityGraph.relationshipCount());
                }
            } else {
                resultBuilder.withNodesCompared(algorithm.nodeCount()).withRelationshipsWritten(result.numberOfSimilarityPairs());
            }
            return Stream.of(resultBuilder.build());
        });
    }
}

