/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.filteredknn;

import java.util.Map;
import org.neo4j.gds.similarity.SimilarityProc;
import org.neo4j.gds.similarity.SimilarityStatsResult;

public class FilteredKnnStatsResult
extends SimilarityStatsResult {
    public final long ranIterations;
    public final boolean didConverge;
    public final long nodePairsConsidered;

    public FilteredKnnStatsResult(long preProcessingMillis, long computeMillis, long postProcessingMillis, long nodesCompared, long nodePairs, Map<String, Object> similarityDistribution, boolean didConverge, long ranIterations, long nodePairsConsidered, Map<String, Object> configuration) {
        super(preProcessingMillis, computeMillis, postProcessingMillis, nodesCompared, nodePairs, similarityDistribution, configuration);
        this.nodePairsConsidered = nodePairsConsidered;
        this.ranIterations = ranIterations;
        this.didConverge = didConverge;
    }

    public static class Builder
    extends SimilarityProc.SimilarityResultBuilder<FilteredKnnStatsResult> {
        private long ranIterations;
        private boolean didConverge;
        private long nodePairsConsidered;

        public FilteredKnnStatsResult build() {
            return new FilteredKnnStatsResult(this.preProcessingMillis, this.computeMillis, this.postProcessingMillis, this.nodesCompared, this.relationshipsWritten, this.distribution(), this.didConverge, this.ranIterations, this.nodePairsConsidered, this.config.toMap());
        }

        public Builder withDidConverge(boolean didConverge) {
            this.didConverge = didConverge;
            return this;
        }

        public Builder withRanIterations(long ranIterations) {
            this.ranIterations = ranIterations;
            return this;
        }

        Builder withNodePairsConsidered(long nodePairsConsidered) {
            this.nodePairsConsidered = nodePairsConsidered;
            return this;
        }
    }
}

