/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.filteredknn;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.StreamProc;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.similarity.SimilarityResult;
import org.neo4j.gds.similarity.filteredknn.FilteredKnn;
import org.neo4j.gds.similarity.filteredknn.FilteredKnnFactory;
import org.neo4j.gds.similarity.filteredknn.FilteredKnnResult;
import org.neo4j.gds.similarity.filteredknn.FilteredKnnStreamConfig;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.knn.filtered.stream", executionMode=ExecutionMode.STREAM)
public class FilteredKnnStreamProc
extends StreamProc<FilteredKnn, FilteredKnnResult, SimilarityResult, FilteredKnnStreamConfig> {
    @Procedure(value="gds.alpha.knn.filtered.stream", mode=Mode.READ)
    @Description(value="The k-nearest neighbor graph algorithm constructs relationships between nodes if the distance between two nodes is among the k nearest distances compared to other nodes. KNN computes distances based on the similarity of node properties. Filtered KNN extends this functionality, allowing filtering on source nodes and target nodes, respectively.")
    public Stream<SimilarityResult> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return (Stream)this.computationResultConsumer().consume(computationResult, this.executionContext());
    }

    protected SimilarityResult streamResult(long originalNodeId, long internalNodeId, NodePropertyValues nodePropertyValues) {
        throw new UnsupportedOperationException("Filtered KNN handles result building individually.");
    }

    protected FilteredKnnStreamConfig newConfig(String username, CypherMapWrapper config) {
        return FilteredKnnStreamConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<FilteredKnn, FilteredKnnStreamConfig> algorithmFactory() {
        return new FilteredKnnFactory();
    }

    public ComputationResultConsumer<FilteredKnn, FilteredKnnResult, FilteredKnnStreamConfig, Stream<SimilarityResult>> computationResultConsumer() {
        return (computationResult, executionContext) -> {
            Graph graph = computationResult.graph();
            if (computationResult.isGraphEmpty()) {
                graph.release();
                return Stream.empty();
            }
            return ((FilteredKnnResult)computationResult.result()).similarityResultStream().map(similarityResult -> {
                similarityResult.node1 = graph.toOriginalNodeId(similarityResult.node1);
                similarityResult.node2 = graph.toOriginalNodeId(similarityResult.node2);
                return similarityResult;
            });
        };
    }
}

