/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.filteredknn;

import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.similarity.SimilarityGraphResult;
import org.neo4j.gds.similarity.SimilarityProc;
import org.neo4j.gds.similarity.SimilarityWriteProc;
import org.neo4j.gds.similarity.filteredknn.FilteredKnn;
import org.neo4j.gds.similarity.filteredknn.FilteredKnnFactory;
import org.neo4j.gds.similarity.filteredknn.FilteredKnnHelpers;
import org.neo4j.gds.similarity.filteredknn.FilteredKnnResult;
import org.neo4j.gds.similarity.filteredknn.FilteredKnnWriteConfig;
import org.neo4j.gds.similarity.filteredknn.FilteredKnnWriteProcResult;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.alpha.knn.filtered.write", executionMode=ExecutionMode.WRITE_RELATIONSHIP)
public class FilteredKnnWriteProc
extends SimilarityWriteProc<FilteredKnn, FilteredKnnResult, FilteredKnnWriteProcResult, FilteredKnnWriteConfig> {
    @Procedure(name="gds.alpha.knn.filtered.write", mode=Mode.WRITE)
    @Description(value="The k-nearest neighbor graph algorithm constructs relationships between nodes if the distance between two nodes is among the k nearest distances compared to other nodes. KNN computes distances based on the similarity of node properties. Filtered KNN extends this functionality, allowing filtering on source nodes and target nodes, respectively.")
    public Stream<FilteredKnnWriteProcResult> write(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.write(this.compute(graphName, configuration));
    }

    @Override
    public String procedureName() {
        return "Filtered KNN";
    }

    @Override
    protected SimilarityProc.SimilarityResultBuilder<FilteredKnnWriteProcResult> resultBuilder(ComputationResult<FilteredKnn, FilteredKnnResult, FilteredKnnWriteConfig> computationResult) {
        if (computationResult.isGraphEmpty()) {
            return new FilteredKnnWriteProcResult.Builder();
        }
        return new FilteredKnnWriteProcResult.Builder().withDidConverge(((FilteredKnnResult)computationResult.result()).didConverge()).withNodePairsConsidered(((FilteredKnnResult)computationResult.result()).nodePairsConsidered()).withRanIterations(((FilteredKnnResult)computationResult.result()).ranIterations());
    }

    protected FilteredKnnWriteConfig newConfig(String username, CypherMapWrapper config) {
        return FilteredKnnWriteConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<FilteredKnn, FilteredKnnWriteConfig> algorithmFactory() {
        return new FilteredKnnFactory();
    }

    @Override
    protected SimilarityGraphResult similarityGraphResult(ComputationResult<FilteredKnn, FilteredKnnResult, FilteredKnnWriteConfig> computationResult) {
        FilteredKnn algorithm = Objects.requireNonNull((FilteredKnn)computationResult.algorithm());
        FilteredKnnWriteConfig config = (FilteredKnnWriteConfig)computationResult.config();
        return FilteredKnnHelpers.computeToGraph(computationResult.graph(), algorithm.nodeCount(), config.concurrency(), Objects.requireNonNull((FilteredKnnResult)computationResult.result()), algorithm.executorService());
    }
}

