/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.filteredknn;

import java.util.Map;
import org.neo4j.gds.similarity.SimilarityProc;
import org.neo4j.gds.similarity.SimilarityWriteResult;

public final class FilteredKnnWriteProcResult
extends SimilarityWriteResult {
    public final long ranIterations;
    public final boolean didConverge;
    public final long nodePairsConsidered;

    private FilteredKnnWriteProcResult(long preProcessingMillis, long computeMillis, long writeMillis, long postProcessingMillis, long nodesCompared, long relationshipsWritten, boolean didConverge, long ranIterations, long nodePairsCompared, Map<String, Object> similarityDistribution, Map<String, Object> configuration) {
        super(preProcessingMillis, computeMillis, writeMillis, postProcessingMillis, nodesCompared, relationshipsWritten, similarityDistribution, configuration);
        this.nodePairsConsidered = nodePairsCompared;
        this.ranIterations = ranIterations;
        this.didConverge = didConverge;
    }

    static class Builder
    extends SimilarityProc.SimilarityResultBuilder<FilteredKnnWriteProcResult> {
        public long ranIterations;
        public boolean didConverge;
        public long nodePairsConsidered;

        Builder() {
        }

        public FilteredKnnWriteProcResult build() {
            return new FilteredKnnWriteProcResult(this.preProcessingMillis, this.computeMillis, this.writeMillis, this.postProcessingMillis, this.nodesCompared, this.relationshipsWritten, this.didConverge, this.ranIterations, this.nodePairsConsidered, this.distribution(), this.config.toMap());
        }

        public Builder withDidConverge(boolean didConverge) {
            this.didConverge = didConverge;
            return this;
        }

        public Builder withRanIterations(long ranIterations) {
            this.ranIterations = ranIterations;
            return this;
        }

        Builder withNodePairsConsidered(long nodePairsConsidered) {
            this.nodePairsConsidered = nodePairsConsidered;
            return this;
        }
    }
}

