/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.filterednodesim;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.BaseProc;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.MemoryEstimationExecutor;
import org.neo4j.gds.executor.ProcedureExecutor;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.similarity.SimilarityMutateResult;
import org.neo4j.gds.similarity.filterednodesim.FilteredNodeSimilarityMutateSpec;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

public class FilteredNodeSimilarityMutateProc
extends BaseProc {
    @Procedure(name="gds.alpha.nodeSimilarity.filtered.mutate", mode=Mode.READ)
    @Description(value="The Filtered Node Similarity algorithm compares a set of nodes based on the nodes they are connected to. Two nodes are considered similar if they share many of the same neighbors. The algorithm computes pair-wise similarities based on Jaccard or Overlap metrics. The filtered variant supports limiting which nodes to compare via source and target node filters.")
    public Stream<SimilarityMutateResult> mutate(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return (Stream)new ProcedureExecutor((AlgorithmSpec)new FilteredNodeSimilarityMutateSpec(), this.executionContext()).compute(graphName, configuration, true, true);
    }

    @Procedure(name="gds.alpha.nodeSimilarity.filtered.mutate.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return new MemoryEstimationExecutor((AlgorithmSpec)new FilteredNodeSimilarityMutateSpec(), this.executionContext()).computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }
}

