/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.filterednodesim;

import java.util.Optional;
import java.util.stream.Stream;
import org.HdrHistogram.DoubleHistogram;
import org.neo4j.gds.MutateComputationResultConsumer;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.PartialIdMap;
import org.neo4j.gds.api.Topology;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.schema.Direction;
import org.neo4j.gds.api.schema.RelationshipPropertySchema;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.huge.HugeGraph;
import org.neo4j.gds.core.loading.SingleTypeRelationships;
import org.neo4j.gds.core.loading.construction.GraphFactory;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilder;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.similarity.SimilarityGraphResult;
import org.neo4j.gds.similarity.SimilarityMutateResult;
import org.neo4j.gds.similarity.SimilarityProc;
import org.neo4j.gds.similarity.filterednodesim.FilteredNodeSimilarityFactory;
import org.neo4j.gds.similarity.filterednodesim.FilteredNodeSimilarityMutateConfig;
import org.neo4j.gds.similarity.nodesim.NodeSimilarity;
import org.neo4j.gds.similarity.nodesim.NodeSimilarityResult;
import org.neo4j.gds.similarity.nodesim.TopKGraph;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;

@GdsCallable(name="gds.alpha.nodeSimilarity.filtered.mutate", description="The Filtered Node Similarity algorithm compares a set of nodes based on the nodes they are connected to. Two nodes are considered similar if they share many of the same neighbors. The algorithm computes pair-wise similarities based on Jaccard or Overlap metrics. The filtered variant supports limiting which nodes to compare via source and target node filters.", executionMode=ExecutionMode.MUTATE_RELATIONSHIP)
public class FilteredNodeSimilarityMutateSpec
implements AlgorithmSpec<NodeSimilarity, NodeSimilarityResult, FilteredNodeSimilarityMutateConfig, Stream<SimilarityMutateResult>, FilteredNodeSimilarityFactory<FilteredNodeSimilarityMutateConfig>> {
    public String name() {
        return "FilteredNodeSimilarityMutate";
    }

    public FilteredNodeSimilarityFactory<FilteredNodeSimilarityMutateConfig> algorithmFactory() {
        return new FilteredNodeSimilarityFactory();
    }

    public NewConfigFunction<FilteredNodeSimilarityMutateConfig> newConfigFunction() {
        return (__, config) -> FilteredNodeSimilarityMutateConfig.of((CypherMapWrapper)config);
    }

    protected AbstractResultBuilder<SimilarityMutateResult> resultBuilder(ComputationResult<NodeSimilarity, NodeSimilarityResult, FilteredNodeSimilarityMutateConfig> computationResult, ExecutionContext executionContext) {
        SimilarityProc.SimilarityResultBuilder<SimilarityMutateResult> resultBuilder = SimilarityProc.withGraphsizeAndTimings(new SimilarityMutateResult.Builder(), computationResult, NodeSimilarityResult::graphResult);
        return resultBuilder;
    }

    public ComputationResultConsumer<NodeSimilarity, NodeSimilarityResult, FilteredNodeSimilarityMutateConfig, Stream<SimilarityMutateResult>> computationResultConsumer() {
        return new MutateComputationResultConsumer<NodeSimilarity, NodeSimilarityResult, FilteredNodeSimilarityMutateConfig, SimilarityMutateResult>(this::resultBuilder){

            protected void updateGraphStore(AbstractResultBuilder<?> resultBuilder, ComputationResult<NodeSimilarity, NodeSimilarityResult, FilteredNodeSimilarityMutateConfig> computationResult, ExecutionContext executionContext) {
                FilteredNodeSimilarityMutateConfig config = (FilteredNodeSimilarityMutateConfig)computationResult.config();
                RelationshipType relationshipType = RelationshipType.of((String)config.mutateRelationshipType());
                SingleTypeRelationships relationships = FilteredNodeSimilarityMutateSpec.this.getRelationships(relationshipType, computationResult, ((NodeSimilarityResult)computationResult.result()).graphResult(), config.mutateProperty(), (SimilarityProc.SimilarityResultBuilder)resultBuilder, executionContext.callContext());
                computationResult.graphStore().addRelationshipType(relationships);
                resultBuilder.withRelationshipsWritten(relationships.topology().elementCount());
            }
        };
    }

    private SingleTypeRelationships getRelationships(RelationshipType relationshipType, ComputationResult<NodeSimilarity, NodeSimilarityResult, FilteredNodeSimilarityMutateConfig> computationResult, SimilarityGraphResult similarityGraphResult, String relationshipPropertyKey, SimilarityProc.SimilarityResultBuilder<SimilarityMutateResult> resultBuilder, ProcedureCallContext callContext) {
        SingleTypeRelationships resultRelationships;
        if (similarityGraphResult.isTopKGraph()) {
            TopKGraph topKGraph = (TopKGraph)similarityGraphResult.similarityGraph();
            RelationshipsBuilder relationshipsBuilder = GraphFactory.initRelationshipsBuilder().nodes((PartialIdMap)topKGraph).relationshipType(relationshipType).orientation(Orientation.NATURAL).addPropertyConfig(GraphFactory.PropertyConfig.of((String)relationshipPropertyKey)).concurrency(1).executorService(Pools.DEFAULT).build();
            Graph idMap = computationResult.graph();
            if (SimilarityProc.shouldComputeHistogram(callContext)) {
                DoubleHistogram histogram = new DoubleHistogram(5);
                topKGraph.forEachNode(arg_0 -> FilteredNodeSimilarityMutateSpec.lambda$getRelationships$2(topKGraph, relationshipsBuilder, (IdMap)idMap, histogram, arg_0));
                resultBuilder.withHistogram(histogram);
            } else {
                topKGraph.forEachNode(arg_0 -> FilteredNodeSimilarityMutateSpec.lambda$getRelationships$4(topKGraph, relationshipsBuilder, (IdMap)idMap, arg_0));
            }
            resultRelationships = relationshipsBuilder.build();
        } else {
            HugeGraph similarityGraph = (HugeGraph)similarityGraphResult.similarityGraph();
            resultRelationships = SingleTypeRelationships.of((RelationshipType)relationshipType, (Topology)similarityGraph.relationshipTopology(), (Direction)similarityGraph.schema().direction(), (Optional)similarityGraph.relationshipProperties(), Optional.of(RelationshipPropertySchema.of((String)relationshipPropertyKey, (ValueType)ValueType.DOUBLE)));
            if (SimilarityProc.shouldComputeHistogram(callContext)) {
                resultBuilder.withHistogram(SimilarityProc.computeHistogram((Graph)similarityGraph));
            }
        }
        return resultRelationships;
    }

    private static /* synthetic */ boolean lambda$getRelationships$4(TopKGraph topKGraph, RelationshipsBuilder relationshipsBuilder, IdMap idMap, long nodeId) {
        topKGraph.forEachRelationship(nodeId, Double.NaN, (sourceNodeId, targetNodeId, property) -> {
            relationshipsBuilder.addFromInternal(idMap.toRootNodeId(sourceNodeId), idMap.toRootNodeId(targetNodeId), property);
            return true;
        });
        return true;
    }

    private static /* synthetic */ boolean lambda$getRelationships$2(TopKGraph topKGraph, RelationshipsBuilder relationshipsBuilder, IdMap idMap, DoubleHistogram histogram, long nodeId) {
        topKGraph.forEachRelationship(nodeId, Double.NaN, (sourceNodeId, targetNodeId, property) -> {
            relationshipsBuilder.addFromInternal(idMap.toRootNodeId(sourceNodeId), idMap.toRootNodeId(targetNodeId), property);
            histogram.recordValue(property);
            return true;
        });
        return true;
    }
}

