/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.filterednodesim;

import java.util.Collections;
import java.util.stream.Stream;
import org.neo4j.gds.LoggingUtil;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.similarity.SimilarityProc;
import org.neo4j.gds.similarity.SimilarityStatsResult;
import org.neo4j.gds.similarity.filterednodesim.FilteredNodeSimilarityFactory;
import org.neo4j.gds.similarity.filterednodesim.FilteredNodeSimilarityStatsConfig;
import org.neo4j.gds.similarity.nodesim.NodeSimilarity;
import org.neo4j.gds.similarity.nodesim.NodeSimilarityResult;
import org.neo4j.gds.similarity.nodesim.NodeSimilarityStatsConfig;
import org.neo4j.logging.Log;

@GdsCallable(name="gds.alpha.nodeSimilarity.filtered.stats", description="The Filtered Node Similarity algorithm compares a set of nodes based on the nodes they are connected to. Two nodes are considered similar if they share many of the same neighbors. The algorithm computes pair-wise similarities based on Jaccard or Overlap metrics. The filtered variant supports limiting which nodes to compare via source and target node filters.", executionMode=ExecutionMode.STATS)
public class FilteredNodeSimilarityStatsSpec
implements AlgorithmSpec<NodeSimilarity, NodeSimilarityResult, FilteredNodeSimilarityStatsConfig, Stream<SimilarityStatsResult>, FilteredNodeSimilarityFactory<FilteredNodeSimilarityStatsConfig>> {
    public String name() {
        return "FilteredNodeSimilarityStats";
    }

    public FilteredNodeSimilarityFactory<FilteredNodeSimilarityStatsConfig> algorithmFactory() {
        return new FilteredNodeSimilarityFactory();
    }

    public NewConfigFunction<FilteredNodeSimilarityStatsConfig> newConfigFunction() {
        return (__, userInput) -> FilteredNodeSimilarityStatsConfig.of((CypherMapWrapper)userInput);
    }

    public ComputationResultConsumer<NodeSimilarity, NodeSimilarityResult, FilteredNodeSimilarityStatsConfig, Stream<SimilarityStatsResult>> computationResultConsumer() {
        return (computationResult, executionContext) -> (Stream)LoggingUtil.runWithExceptionLogging((String)"Graph stats failed", (Log)executionContext.log(), () -> {
            NodeSimilarityStatsConfig config = (NodeSimilarityStatsConfig)computationResult.config();
            if (computationResult.isGraphEmpty()) {
                return Stream.of(new SimilarityStatsResult(computationResult.preProcessingMillis(), 0L, 0L, 0L, 0L, Collections.emptyMap(), config.toMap()));
            }
            SimilarityProc.SimilarityResultBuilder<SimilarityStatsResult> resultBuilder = SimilarityProc.withGraphsizeAndTimings(new SimilarityStatsResult.Builder(), computationResult, NodeSimilarityResult::graphResult);
            if (SimilarityProc.shouldComputeHistogram(executionContext.callContext())) {
                try (ProgressTimer ignored = resultBuilder.timePostProcessing();){
                    resultBuilder.withHistogram(SimilarityProc.computeHistogram(((NodeSimilarityResult)computationResult.result()).graphResult().similarityGraph()));
                }
            }
            return Stream.of((SimilarityStatsResult)resultBuilder.build());
        });
    }
}

