/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.filterednodesim;

import java.util.Optional;
import java.util.stream.Stream;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.similarity.SimilarityResult;
import org.neo4j.gds.similarity.filterednodesim.FilteredNodeSimilarityFactory;
import org.neo4j.gds.similarity.filterednodesim.FilteredNodeSimilarityStreamConfig;
import org.neo4j.gds.similarity.nodesim.NodeSimilarity;
import org.neo4j.gds.similarity.nodesim.NodeSimilarityResult;

@GdsCallable(name="gds.alpha.nodeSimilarity.filtered.stream", description="The Filtered Node Similarity algorithm compares a set of nodes based on the nodes they are connected to. Two nodes are considered similar if they share many of the same neighbors. The algorithm computes pair-wise similarities based on Jaccard or Overlap metrics. The filtered variant supports limiting which nodes to compare via source and target node filters.", executionMode=ExecutionMode.STREAM)
public class FilteredNodeSimilarityStreamSpec
implements AlgorithmSpec<NodeSimilarity, NodeSimilarityResult, FilteredNodeSimilarityStreamConfig, Stream<SimilarityResult>, FilteredNodeSimilarityFactory<FilteredNodeSimilarityStreamConfig>> {
    public String name() {
        return "FilteredNodeSimilarityStream";
    }

    public FilteredNodeSimilarityFactory<FilteredNodeSimilarityStreamConfig> algorithmFactory() {
        return new FilteredNodeSimilarityFactory();
    }

    public NewConfigFunction<FilteredNodeSimilarityStreamConfig> newConfigFunction() {
        return (__, config) -> FilteredNodeSimilarityStreamConfig.of((CypherMapWrapper)config);
    }

    public ComputationResultConsumer<NodeSimilarity, NodeSimilarityResult, FilteredNodeSimilarityStreamConfig, Stream<SimilarityResult>> computationResultConsumer() {
        return (computationResult, executionContext) -> {
            Graph graph = computationResult.graph();
            Stream similarityResultStream = Optional.ofNullable((NodeSimilarityResult)computationResult.result()).map(NodeSimilarityResult::streamResult).orElseGet(Stream::empty);
            return similarityResultStream.map(internalSimilarityResult -> {
                internalSimilarityResult.node1 = graph.toOriginalNodeId(internalSimilarityResult.node1);
                internalSimilarityResult.node2 = graph.toOriginalNodeId(internalSimilarityResult.node2);
                return internalSimilarityResult;
            });
        };
    }
}

