/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.filterednodesim;

import java.util.stream.Stream;
import org.HdrHistogram.DoubleHistogram;
import org.neo4j.gds.LoggingUtil;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.TaskProgressTracker;
import org.neo4j.gds.core.write.RelationshipExporter;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.similarity.SimilarityGraphResult;
import org.neo4j.gds.similarity.SimilarityProc;
import org.neo4j.gds.similarity.SimilarityWriteResult;
import org.neo4j.gds.similarity.filterednodesim.FilteredNodeSimilarityFactory;
import org.neo4j.gds.similarity.filterednodesim.FilteredNodeSimilarityWriteConfig;
import org.neo4j.gds.similarity.nodesim.NodeSimilarity;
import org.neo4j.gds.similarity.nodesim.NodeSimilarityResult;
import org.neo4j.logging.Log;

@GdsCallable(name="gds.alpha.nodeSimilarity.filtered.write", description="The Filtered Node Similarity algorithm compares a set of nodes based on the nodes they are connected to. Two nodes are considered similar if they share many of the same neighbors. The algorithm computes pair-wise similarities based on Jaccard or Overlap metrics. The filtered variant supports limiting which nodes to compare via source and target node filters.", executionMode=ExecutionMode.WRITE_RELATIONSHIP)
public class FilteredNodeSimilarityWriteSpec
implements AlgorithmSpec<NodeSimilarity, NodeSimilarityResult, FilteredNodeSimilarityWriteConfig, Stream<SimilarityWriteResult>, FilteredNodeSimilarityFactory<FilteredNodeSimilarityWriteConfig>> {
    public String name() {
        return "FilteredNodeSimilarityWrite";
    }

    public FilteredNodeSimilarityFactory<FilteredNodeSimilarityWriteConfig> algorithmFactory() {
        return new FilteredNodeSimilarityFactory();
    }

    public NewConfigFunction<FilteredNodeSimilarityWriteConfig> newConfigFunction() {
        return (__, userInput) -> FilteredNodeSimilarityWriteConfig.of((CypherMapWrapper)userInput);
    }

    public ComputationResultConsumer<NodeSimilarity, NodeSimilarityResult, FilteredNodeSimilarityWriteConfig, Stream<SimilarityWriteResult>> computationResultConsumer() {
        return (computationResult, executionContext) -> (Stream)LoggingUtil.runWithExceptionLogging((String)"Graph write failed", (Log)executionContext.log(), () -> {
            FilteredNodeSimilarityWriteConfig config = (FilteredNodeSimilarityWriteConfig)computationResult.config();
            SimilarityWriteResult.Builder resultBuilder = new SimilarityWriteResult.Builder();
            if (computationResult.isGraphEmpty()) {
                return Stream.of((SimilarityWriteResult)resultBuilder.withConfig((AlgoBaseConfig)config).build());
            }
            NodeSimilarity algorithm = (NodeSimilarity)computationResult.algorithm();
            SimilarityGraphResult similarityGraphResult = ((NodeSimilarityResult)computationResult.result()).graphResult();
            Graph similarityGraph = similarityGraphResult.similarityGraph();
            Graph rootIdMap = similarityGraphResult.isTopKGraph() ? similarityGraph : computationResult.graphStore().nodes();
            SimilarityProc.withGraphsizeAndTimings(resultBuilder, computationResult, ignore -> similarityGraphResult);
            if (similarityGraph.relationshipCount() > 0L) {
                String writeRelationshipType = config.writeRelationshipType();
                String writeProperty = config.writeProperty();
                LoggingUtil.runWithExceptionLogging((String)(this.name() + " write-back failed"), (Log)executionContext.log(), () -> this.lambda$computationResultConsumer$3(resultBuilder, similarityGraph, executionContext, (IdMap)rootIdMap, algorithm, writeRelationshipType, writeProperty));
            }
            return Stream.of(resultBuilder.build());
        });
    }

    private /* synthetic */ Integer lambda$computationResultConsumer$3(SimilarityWriteResult.Builder resultBuilder, Graph similarityGraph, ExecutionContext executionContext, IdMap rootIdMap, NodeSimilarity algorithm, String writeRelationshipType, String writeProperty) {
        try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> ((SimilarityWriteResult.Builder)resultBuilder).withWriteMillis(arg_0));){
            TaskProgressTracker progressTracker = new TaskProgressTracker(RelationshipExporter.baseTask((String)this.name(), (long)similarityGraph.relationshipCount()), executionContext.log(), 1, executionContext.taskRegistryFactory());
            RelationshipExporter exporter = executionContext.relationshipExporterBuilder().withIdMappingOperator(arg_0 -> ((IdMap)rootIdMap).toOriginalNodeId(arg_0)).withGraph(similarityGraph).withTerminationFlag(algorithm.getTerminationFlag()).withProgressTracker((ProgressTracker)progressTracker).build();
            if (SimilarityProc.shouldComputeHistogram(executionContext.callContext())) {
                DoubleHistogram histogram = new DoubleHistogram(5);
                exporter.write(writeRelationshipType, writeProperty, (node1, node2, similarity) -> {
                    histogram.recordValue(similarity);
                    return true;
                });
                resultBuilder.withHistogram(histogram);
            } else {
                exporter.write(writeRelationshipType, writeProperty);
            }
        }
        return 1;
    }
}

