/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.knn;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.Topology;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.schema.Direction;
import org.neo4j.gds.api.schema.RelationshipPropertySchema;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.huge.HugeGraph;
import org.neo4j.gds.core.loading.SingleTypeRelationships;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.similarity.SimilarityGraphResult;
import org.neo4j.gds.similarity.SimilarityMutateResult;
import org.neo4j.gds.similarity.SimilarityProc;
import org.neo4j.gds.similarity.knn.Knn;
import org.neo4j.gds.similarity.knn.KnnFactory;
import org.neo4j.gds.similarity.knn.KnnMutateConfig;
import org.neo4j.gds.similarity.knn.KnnWriteProc;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.knn.mutate", description="The k-nearest neighbor graph algorithm constructs relationships between nodes if the distance between two nodes is among the k nearest distances compared to other nodes.KNN computes distances based on the similarity of node properties", executionMode=ExecutionMode.MUTATE_RELATIONSHIP)
public class KnnMutateProc
extends AlgoBaseProc<Knn, Knn.Result, KnnMutateConfig, Result> {
    @Procedure(name="gds.knn.mutate", mode=Mode.READ)
    @Description(value="The k-nearest neighbor graph algorithm constructs relationships between nodes if the distance between two nodes is among the k nearest distances compared to other nodes.KNN computes distances based on the similarity of node properties")
    public Stream<Result> mutate(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return (Stream)this.computationResultConsumer().consume(computationResult, this.executionContext());
    }

    @Procedure(value="gds.knn.mutate.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected KnnMutateConfig newConfig(String username, CypherMapWrapper config) {
        return KnnMutateConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<Knn, KnnMutateConfig> algorithmFactory() {
        return new KnnFactory();
    }

    public ComputationResultConsumer<Knn, Knn.Result, KnnMutateConfig, Stream<Result>> computationResultConsumer() {
        return (computationResult, executionContext) -> (Stream)this.runWithExceptionLogging("Graph mutation failed", () -> {
            SimilarityGraphResult similarityGraphResult;
            KnnMutateConfig config = (KnnMutateConfig)computationResult.config();
            Knn.Result result = (Knn.Result)computationResult.result();
            if (computationResult.isGraphEmpty()) {
                return Stream.of(new Result(computationResult.preProcessingMillis(), 0L, 0L, 0L, 0L, 0L, Collections.emptyMap(), true, 0L, 0L, config.toMap()));
            }
            Knn algorithm = Objects.requireNonNull((Knn)computationResult.algorithm());
            AtomicLong mutateMillis = new AtomicLong();
            try (ProgressTimer ignored = ProgressTimer.start(mutateMillis::addAndGet);){
                similarityGraphResult = KnnWriteProc.computeToGraph(computationResult.graph(), algorithm.nodeCount(), config.concurrency(), Objects.requireNonNull(result), algorithm.executorService());
            }
            Result.Builder resultBuilder = new Result.Builder().ranIterations(result.ranIterations()).didConverge(result.didConverge()).withNodePairsConsidered(result.nodePairsConsidered());
            SimilarityProc.withGraphsizeAndTimings(resultBuilder, computationResult, ignore -> similarityGraphResult);
            try (ProgressTimer ignored = ProgressTimer.start(mutateMillis::addAndGet);){
                HugeGraph similarityGraph = (HugeGraph)similarityGraphResult.similarityGraph();
                this.computeHistogram((Graph)similarityGraph, resultBuilder);
                RelationshipType relationshipType = RelationshipType.of((String)config.mutateRelationshipType());
                computationResult.graphStore().addRelationshipType(SingleTypeRelationships.of((RelationshipType)relationshipType, (Topology)similarityGraph.relationshipTopology(), (Direction)similarityGraphResult.direction(), (Optional)similarityGraph.relationshipProperties(), Optional.of(RelationshipPropertySchema.of((String)config.mutateProperty(), (ValueType)ValueType.DOUBLE))));
            }
            resultBuilder.withMutateMillis(mutateMillis.get());
            return Stream.of(resultBuilder.build());
        });
    }

    private void computeHistogram(Graph similarityGraph, Result.Builder resultBuilder) {
        if (SimilarityProc.shouldComputeHistogram(this.callContext)) {
            resultBuilder.withHistogram(SimilarityProc.computeHistogram(similarityGraph));
        }
    }

    public static class Result
    extends SimilarityMutateResult {
        public final long ranIterations;
        public final long nodePairsConsidered;
        public final boolean didConverge;

        public Result(long preProcessingMillis, long computeMillis, long mutateMillis, long postProcessingMillis, long nodesCompared, long relationshipsWritten, Map<String, Object> similarityDistribution, boolean didConverge, long ranIterations, long nodePairsConsidered, Map<String, Object> configuration) {
            super(preProcessingMillis, computeMillis, mutateMillis, postProcessingMillis, nodesCompared, relationshipsWritten, similarityDistribution, configuration);
            this.ranIterations = ranIterations;
            this.didConverge = didConverge;
            this.nodePairsConsidered = nodePairsConsidered;
        }

        public static class Builder
        extends SimilarityProc.SimilarityResultBuilder<SimilarityMutateResult> {
            private long ranIterations;
            private boolean didConverge;
            private long nodePairsConsidered;

            public Result build() {
                return new Result(this.preProcessingMillis, this.computeMillis, this.mutateMillis, this.postProcessingMillis, this.nodesCompared, this.relationshipsWritten, this.distribution(), this.didConverge, this.ranIterations, this.nodePairsConsidered, this.config.toMap());
            }

            public Builder didConverge(boolean didConverge) {
                this.didConverge = didConverge;
                return this;
            }

            public Builder ranIterations(long ranIterations) {
                this.ranIterations = ranIterations;
                return this;
            }

            Builder withNodePairsConsidered(long nodePairsConsidered) {
                this.nodePairsConsidered = nodePairsConsidered;
                return this;
            }
        }
    }
}

