/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.knn;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.StatsProc;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.similarity.SimilarityGraphResult;
import org.neo4j.gds.similarity.SimilarityProc;
import org.neo4j.gds.similarity.SimilarityStatsResult;
import org.neo4j.gds.similarity.knn.Knn;
import org.neo4j.gds.similarity.knn.KnnFactory;
import org.neo4j.gds.similarity.knn.KnnStatsConfig;
import org.neo4j.gds.similarity.knn.KnnWriteProc;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.knn.stats", description="Executes the algorithm and returns result statistics without writing the result to Neo4j.", executionMode=ExecutionMode.STATS)
public final class KnnStatsProc
extends StatsProc<Knn, Knn.Result, Result, KnnStatsConfig> {
    @Procedure(name="gds.knn.stats", mode=Mode.READ)
    @Description(value="Executes the algorithm and returns result statistics without writing the result to Neo4j.")
    public Stream<Result> stats(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stats((ComputationResult<Knn, Knn.Result, KnnStatsConfig>)this.compute(graphName, configuration));
    }

    @Procedure(value="gds.knn.stats.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected KnnStatsConfig newConfig(String username, CypherMapWrapper config) {
        return KnnStatsConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<Knn, KnnStatsConfig> algorithmFactory() {
        return new KnnFactory();
    }

    protected AbstractResultBuilder<Result> resultBuilder(ComputationResult<Knn, Knn.Result, KnnStatsConfig> computeResult, ExecutionContext executionContext) {
        throw new UnsupportedOperationException("Knn handles result building individually.");
    }

    public Stream<Result> stats(ComputationResult<Knn, Knn.Result, KnnStatsConfig> computationResult) {
        return (Stream)this.runWithExceptionLogging("Graph stats failed", () -> {
            KnnStatsConfig config = (KnnStatsConfig)computationResult.config();
            if (computationResult.isGraphEmpty()) {
                return Stream.of(new Result(computationResult.preProcessingMillis(), 0L, 0L, 0L, 0L, Collections.emptyMap(), true, 0L, 0L, config.toMap()));
            }
            Knn algorithm = Objects.requireNonNull((Knn)computationResult.algorithm());
            Knn.Result result = Objects.requireNonNull((Knn.Result)computationResult.result());
            Result.Builder resultBuilder = new Result.Builder().withRanIterations(result.ranIterations()).withNodePairsConsidered(result.nodePairsConsidered()).withDidConverge(result.didConverge());
            SimilarityProc.resultBuilderWithTimings(resultBuilder, computationResult);
            if (SimilarityProc.shouldComputeHistogram(this.callContext)) {
                try (ProgressTimer ignored = resultBuilder.timePostProcessing();){
                    SimilarityGraphResult similarityGraphResult = KnnWriteProc.computeToGraph(computationResult.graph(), algorithm.nodeCount(), config.concurrency(), result, algorithm.executorService());
                    Graph similarityGraph = similarityGraphResult.similarityGraph();
                    resultBuilder.withHistogram(SimilarityProc.computeHistogram(similarityGraph)).withNodesCompared(similarityGraphResult.comparedNodes()).withRelationshipsWritten(similarityGraph.relationshipCount());
                }
            } else {
                resultBuilder.withNodesCompared(algorithm.nodeCount()).withRelationshipsWritten(result.totalSimilarityPairs());
            }
            return Stream.of(resultBuilder.build());
        });
    }

    public static class Result
    extends SimilarityStatsResult {
        public final long ranIterations;
        public final boolean didConverge;
        public final long nodePairsConsidered;

        public Result(long preProcessingMillis, long computeMillis, long postProcessingMillis, long nodesCompared, long nodePairs, Map<String, Object> similarityDistribution, boolean didConverge, long ranIterations, long nodePairsConsidered, Map<String, Object> configuration) {
            super(preProcessingMillis, computeMillis, postProcessingMillis, nodesCompared, nodePairs, similarityDistribution, configuration);
            this.nodePairsConsidered = nodePairsConsidered;
            this.ranIterations = ranIterations;
            this.didConverge = didConverge;
        }

        public static class Builder
        extends SimilarityProc.SimilarityResultBuilder<Result> {
            private long ranIterations;
            private boolean didConverge;
            private long nodePairsConsidered;

            public Result build() {
                return new Result(this.preProcessingMillis, this.computeMillis, this.postProcessingMillis, this.nodesCompared, this.relationshipsWritten, this.distribution(), this.didConverge, this.ranIterations, this.nodePairsConsidered, this.config.toMap());
            }

            public Builder withDidConverge(boolean didConverge) {
                this.didConverge = didConverge;
                return this;
            }

            public Builder withRanIterations(long ranIterations) {
                this.ranIterations = ranIterations;
                return this;
            }

            Builder withNodePairsConsidered(long nodePairsConsidered) {
                this.nodePairsConsidered = nodePairsConsidered;
                return this;
            }
        }
    }
}

