/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.knn;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.StreamProc;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.similarity.SimilarityResult;
import org.neo4j.gds.similarity.knn.Knn;
import org.neo4j.gds.similarity.knn.KnnFactory;
import org.neo4j.gds.similarity.knn.KnnStreamConfig;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.knn.stream", description="The k-nearest neighbor graph algorithm constructs relationships between nodes if the distance between two nodes is among the k nearest distances compared to other nodes.KNN computes distances based on the similarity of node properties", executionMode=ExecutionMode.STREAM)
public class KnnStreamProc
extends StreamProc<Knn, Knn.Result, SimilarityResult, KnnStreamConfig> {
    @Procedure(value="gds.knn.stream", mode=Mode.READ)
    @Description(value="The k-nearest neighbor graph algorithm constructs relationships between nodes if the distance between two nodes is among the k nearest distances compared to other nodes.KNN computes distances based on the similarity of node properties")
    public Stream<SimilarityResult> stream(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return (Stream)this.computationResultConsumer().consume(computationResult, this.executionContext());
    }

    @Procedure(value="gds.knn.stream.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected SimilarityResult streamResult(long originalNodeId, long internalNodeId, NodePropertyValues nodePropertyValues) {
        throw new UnsupportedOperationException("Knn handles result building individually.");
    }

    protected KnnStreamConfig newConfig(String username, CypherMapWrapper config) {
        return KnnStreamConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<Knn, KnnStreamConfig> algorithmFactory() {
        return new KnnFactory();
    }

    public ComputationResultConsumer<Knn, Knn.Result, KnnStreamConfig, Stream<SimilarityResult>> computationResultConsumer() {
        return (computationResult, executionContext) -> {
            Graph graph = computationResult.graph();
            if (computationResult.isGraphEmpty()) {
                graph.release();
                return Stream.empty();
            }
            return ((Knn.Result)computationResult.result()).streamSimilarityResult().map(similarityResult -> {
                similarityResult.node1 = graph.toOriginalNodeId(similarityResult.node1);
                similarityResult.node2 = graph.toOriginalNodeId(similarityResult.node2);
                return similarityResult;
            });
        };
    }
}

