/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.knn;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.similarity.SimilarityGraphBuilder;
import org.neo4j.gds.similarity.SimilarityGraphResult;
import org.neo4j.gds.similarity.SimilarityProc;
import org.neo4j.gds.similarity.SimilarityWriteProc;
import org.neo4j.gds.similarity.SimilarityWriteResult;
import org.neo4j.gds.similarity.knn.Knn;
import org.neo4j.gds.similarity.knn.KnnFactory;
import org.neo4j.gds.similarity.knn.KnnWriteConfig;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.knn.write", description="The k-nearest neighbor graph algorithm constructs relationships between nodes if the distance between two nodes is among the k nearest distances compared to other nodes.KNN computes distances based on the similarity of node properties", executionMode=ExecutionMode.WRITE_RELATIONSHIP)
public class KnnWriteProc
extends SimilarityWriteProc<Knn, Knn.Result, Result, KnnWriteConfig> {
    @Procedure(name="gds.knn.write", mode=Mode.WRITE)
    @Description(value="The k-nearest neighbor graph algorithm constructs relationships between nodes if the distance between two nodes is among the k nearest distances compared to other nodes.KNN computes distances based on the similarity of node properties")
    public Stream<Result> write(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.write(this.compute(graphName, configuration));
    }

    @Procedure(value="gds.knn.write.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    @Override
    public String procedureName() {
        return "KNN";
    }

    @Override
    protected SimilarityProc.SimilarityResultBuilder<Result> resultBuilder(ComputationResult<Knn, Knn.Result, KnnWriteConfig> computationResult) {
        if (computationResult.isGraphEmpty()) {
            return new Result.Builder();
        }
        return new Result.Builder().withDidConverge(((Knn.Result)computationResult.result()).didConverge()).withNodePairsConsidered(((Knn.Result)computationResult.result()).nodePairsConsidered()).withRanIterations(((Knn.Result)computationResult.result()).ranIterations());
    }

    protected KnnWriteConfig newConfig(String username, CypherMapWrapper config) {
        return KnnWriteConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<Knn, KnnWriteConfig> algorithmFactory() {
        return new KnnFactory();
    }

    @Override
    protected SimilarityGraphResult similarityGraphResult(ComputationResult<Knn, Knn.Result, KnnWriteConfig> computationResult) {
        Knn algorithm = Objects.requireNonNull((Knn)computationResult.algorithm());
        KnnWriteConfig config = (KnnWriteConfig)computationResult.config();
        return KnnWriteProc.computeToGraph(computationResult.graph(), algorithm.nodeCount(), config.concurrency(), Objects.requireNonNull((Knn.Result)computationResult.result()), algorithm.executorService());
    }

    static SimilarityGraphResult computeToGraph(Graph graph, long nodeCount, int concurrency, Knn.Result result, ExecutorService executor) {
        Graph similarityGraph = new SimilarityGraphBuilder((IdMap)graph, concurrency, executor).build(result.streamSimilarityResult());
        return new SimilarityGraphResult(similarityGraph, nodeCount, false);
    }

    public static class Result
    extends SimilarityWriteResult {
        public final long ranIterations;
        public final boolean didConverge;
        public final long nodePairsConsidered;

        Result(long preProcessingMillis, long computeMillis, long writeMillis, long postProcessingMillis, long nodesCompared, long relationshipsWritten, boolean didConverge, long ranIterations, long nodePairsCompared, Map<String, Object> similarityDistribution, Map<String, Object> configuration) {
            super(preProcessingMillis, computeMillis, writeMillis, postProcessingMillis, nodesCompared, relationshipsWritten, similarityDistribution, configuration);
            this.nodePairsConsidered = nodePairsCompared;
            this.ranIterations = ranIterations;
            this.didConverge = didConverge;
        }

        static class Builder
        extends SimilarityProc.SimilarityResultBuilder<Result> {
            public long ranIterations;
            public boolean didConverge;
            public long nodePairsConsidered;

            Builder() {
            }

            public Result build() {
                return new Result(this.preProcessingMillis, this.computeMillis, this.writeMillis, this.postProcessingMillis, this.nodesCompared, this.relationshipsWritten, this.didConverge, this.ranIterations, this.nodePairsConsidered, this.distribution(), this.config.toMap());
            }

            public Builder withDidConverge(boolean didConverge) {
                this.didConverge = didConverge;
                return this;
            }

            public Builder withRanIterations(long ranIterations) {
                this.ranIterations = ranIterations;
                return this;
            }

            Builder withNodePairsConsidered(long nodePairsConsidered) {
                this.nodePairsConsidered = nodePairsConsidered;
                return this;
            }
        }
    }
}

