/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.nodesim;

import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import org.HdrHistogram.DoubleHistogram;
import org.neo4j.gds.AlgoBaseProc;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.PartialIdMap;
import org.neo4j.gds.api.Topology;
import org.neo4j.gds.api.nodeproperties.ValueType;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.api.schema.Direction;
import org.neo4j.gds.api.schema.RelationshipPropertySchema;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.huge.HugeGraph;
import org.neo4j.gds.core.loading.SingleTypeRelationships;
import org.neo4j.gds.core.loading.construction.GraphFactory;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilder;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ComputationResultConsumer;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.similarity.SimilarityGraphResult;
import org.neo4j.gds.similarity.SimilarityMutateResult;
import org.neo4j.gds.similarity.SimilarityProc;
import org.neo4j.gds.similarity.nodesim.NodeSimilarity;
import org.neo4j.gds.similarity.nodesim.NodeSimilarityFactory;
import org.neo4j.gds.similarity.nodesim.NodeSimilarityMutateConfig;
import org.neo4j.gds.similarity.nodesim.NodeSimilarityResult;
import org.neo4j.gds.similarity.nodesim.TopKGraph;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.nodeSimilarity.mutate", description="The Node Similarity algorithm compares a set of nodes based on the nodes they are connected to. Two nodes are considered similar if they share many of the same neighbors. Node Similarity computes pair-wise similarities based on the Jaccard metric.", executionMode=ExecutionMode.MUTATE_RELATIONSHIP)
public class NodeSimilarityMutateProc
extends AlgoBaseProc<NodeSimilarity, NodeSimilarityResult, NodeSimilarityMutateConfig, SimilarityMutateResult> {
    @Procedure(name="gds.nodeSimilarity.mutate", mode=Mode.READ)
    @Description(value="The Node Similarity algorithm compares a set of nodes based on the nodes they are connected to. Two nodes are considered similar if they share many of the same neighbors. Node Similarity computes pair-wise similarities based on the Jaccard metric.")
    public Stream<SimilarityMutateResult> mutate(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        ComputationResult computationResult = this.compute(graphName, configuration);
        return (Stream)this.computationResultConsumer().consume(computationResult, this.executionContext());
    }

    @Procedure(value="gds.nodeSimilarity.mutate.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected NodeSimilarityMutateConfig newConfig(String username, CypherMapWrapper userInput) {
        return NodeSimilarityMutateConfig.of((CypherMapWrapper)userInput);
    }

    public GraphAlgorithmFactory<NodeSimilarity, NodeSimilarityMutateConfig> algorithmFactory() {
        return new NodeSimilarityFactory();
    }

    protected NodePropertyValues nodeProperties(ComputationResult<NodeSimilarity, NodeSimilarityResult, NodeSimilarityMutateConfig> computationResult) {
        throw new UnsupportedOperationException("NodeSimilarity does not mutate node properties.");
    }

    public ComputationResultConsumer<NodeSimilarity, NodeSimilarityResult, NodeSimilarityMutateConfig, Stream<SimilarityMutateResult>> computationResultConsumer() {
        return (computationResult, executionContext) -> (Stream)this.runWithExceptionLogging("Graph mutation failed", () -> {
            NodeSimilarityMutateConfig config = (NodeSimilarityMutateConfig)computationResult.config();
            if (computationResult.isGraphEmpty()) {
                return Stream.of(new SimilarityMutateResult(computationResult.preProcessingMillis(), 0L, 0L, 0L, 0L, 0L, Collections.emptyMap(), config.toMap()));
            }
            SimilarityProc.SimilarityResultBuilder<SimilarityMutateResult> resultBuilder = SimilarityProc.withGraphsizeAndTimings(new SimilarityMutateResult.Builder(), computationResult, NodeSimilarityResult::graphResult);
            try (ProgressTimer ignored = ProgressTimer.start(arg_0 -> resultBuilder.withMutateMillis(arg_0));){
                RelationshipType relationshipType = RelationshipType.of((String)config.mutateRelationshipType());
                SingleTypeRelationships resultRelationships = this.getRelationships(relationshipType, (ComputationResult<NodeSimilarity, NodeSimilarityResult, NodeSimilarityMutateConfig>)computationResult, ((NodeSimilarityResult)computationResult.result()).graphResult(), config.mutateProperty(), resultBuilder);
                computationResult.graphStore().addRelationshipType(resultRelationships);
            }
            return Stream.of((SimilarityMutateResult)resultBuilder.build());
        });
    }

    private SingleTypeRelationships getRelationships(RelationshipType relationshipType, ComputationResult<NodeSimilarity, NodeSimilarityResult, NodeSimilarityMutateConfig> computationResult, SimilarityGraphResult similarityGraphResult, String relationshipPropertyKey, SimilarityProc.SimilarityResultBuilder<SimilarityMutateResult> resultBuilder) {
        SingleTypeRelationships relationships;
        if (similarityGraphResult.isTopKGraph()) {
            TopKGraph topKGraph = (TopKGraph)similarityGraphResult.similarityGraph();
            RelationshipsBuilder relationshipsBuilder = GraphFactory.initRelationshipsBuilder().nodes((PartialIdMap)topKGraph).relationshipType(relationshipType).orientation(Orientation.NATURAL).addPropertyConfig(GraphFactory.PropertyConfig.of((String)relationshipPropertyKey)).concurrency(1).executorService(Pools.DEFAULT).build();
            Graph idMap = computationResult.graph();
            if (SimilarityProc.shouldComputeHistogram(this.callContext)) {
                DoubleHistogram histogram = new DoubleHistogram(5);
                topKGraph.forEachNode(arg_0 -> NodeSimilarityMutateProc.lambda$getRelationships$3(topKGraph, relationshipsBuilder, (IdMap)idMap, histogram, arg_0));
                resultBuilder.withHistogram(histogram);
            } else {
                topKGraph.forEachNode(arg_0 -> NodeSimilarityMutateProc.lambda$getRelationships$5(topKGraph, relationshipsBuilder, (IdMap)idMap, arg_0));
            }
            relationships = relationshipsBuilder.build();
        } else {
            HugeGraph similarityGraph = (HugeGraph)similarityGraphResult.similarityGraph();
            relationships = SingleTypeRelationships.of((RelationshipType)relationshipType, (Topology)similarityGraph.relationshipTopology(), (Direction)similarityGraph.schema().direction(), (Optional)similarityGraph.relationshipProperties(), Optional.of(RelationshipPropertySchema.of((String)relationshipPropertyKey, (ValueType)ValueType.DOUBLE)));
            if (SimilarityProc.shouldComputeHistogram(this.callContext)) {
                resultBuilder.withHistogram(SimilarityProc.computeHistogram((Graph)similarityGraph));
            }
        }
        return relationships;
    }

    private static /* synthetic */ boolean lambda$getRelationships$5(TopKGraph topKGraph, RelationshipsBuilder relationshipsBuilder, IdMap idMap, long nodeId) {
        topKGraph.forEachRelationship(nodeId, Double.NaN, (sourceNodeId, targetNodeId, property) -> {
            relationshipsBuilder.addFromInternal(idMap.toRootNodeId(sourceNodeId), idMap.toRootNodeId(targetNodeId), property);
            return true;
        });
        return true;
    }

    private static /* synthetic */ boolean lambda$getRelationships$3(TopKGraph topKGraph, RelationshipsBuilder relationshipsBuilder, IdMap idMap, DoubleHistogram histogram, long nodeId) {
        topKGraph.forEachRelationship(nodeId, Double.NaN, (sourceNodeId, targetNodeId, property) -> {
            relationshipsBuilder.addFromInternal(idMap.toRootNodeId(sourceNodeId), idMap.toRootNodeId(targetNodeId), property);
            histogram.recordValue(property);
            return true;
        });
        return true;
    }
}

