/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.nodesim;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.StatsProc;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.result.AbstractResultBuilder;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.similarity.SimilarityProc;
import org.neo4j.gds.similarity.SimilarityStatsResult;
import org.neo4j.gds.similarity.nodesim.NodeSimilarity;
import org.neo4j.gds.similarity.nodesim.NodeSimilarityFactory;
import org.neo4j.gds.similarity.nodesim.NodeSimilarityResult;
import org.neo4j.gds.similarity.nodesim.NodeSimilarityStatsConfig;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.nodeSimilarity.stats", description="Executes the algorithm and returns result statistics without writing the result to Neo4j.", executionMode=ExecutionMode.STATS)
public class NodeSimilarityStatsProc
extends StatsProc<NodeSimilarity, NodeSimilarityResult, SimilarityStatsResult, NodeSimilarityStatsConfig> {
    @Procedure(name="gds.nodeSimilarity.stats", mode=Mode.READ)
    @Description(value="Executes the algorithm and returns result statistics without writing the result to Neo4j.")
    public Stream<SimilarityStatsResult> stats(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.stats((ComputationResult<NodeSimilarity, NodeSimilarityResult, NodeSimilarityStatsConfig>)this.compute(graphName, configuration));
    }

    @Procedure(value="gds.nodeSimilarity.stats.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    protected NodeSimilarityStatsConfig newConfig(String username, CypherMapWrapper config) {
        return NodeSimilarityStatsConfig.of((CypherMapWrapper)config);
    }

    public GraphAlgorithmFactory<NodeSimilarity, NodeSimilarityStatsConfig> algorithmFactory() {
        return new NodeSimilarityFactory();
    }

    protected AbstractResultBuilder<SimilarityStatsResult> resultBuilder(ComputationResult<NodeSimilarity, NodeSimilarityResult, NodeSimilarityStatsConfig> computeResult, ExecutionContext executionContext) {
        throw new UnsupportedOperationException("NodeSimilarity handles result building individually.");
    }

    public Stream<SimilarityStatsResult> stats(ComputationResult<NodeSimilarity, NodeSimilarityResult, NodeSimilarityStatsConfig> computationResult) {
        return (Stream)this.runWithExceptionLogging("Graph stats failed", () -> {
            NodeSimilarityStatsConfig config = (NodeSimilarityStatsConfig)computationResult.config();
            if (computationResult.isGraphEmpty()) {
                return Stream.of(new SimilarityStatsResult(computationResult.preProcessingMillis(), 0L, 0L, 0L, 0L, Collections.emptyMap(), config.toMap()));
            }
            SimilarityProc.SimilarityResultBuilder<SimilarityStatsResult> resultBuilder = SimilarityProc.withGraphsizeAndTimings(new SimilarityStatsResult.Builder(), computationResult, NodeSimilarityResult::graphResult);
            if (SimilarityProc.shouldComputeHistogram(this.callContext)) {
                try (ProgressTimer ignored = resultBuilder.timePostProcessing();){
                    resultBuilder.withHistogram(SimilarityProc.computeHistogram(((NodeSimilarityResult)computationResult.result()).graphResult().similarityGraph()));
                }
            }
            return Stream.of((SimilarityStatsResult)resultBuilder.build());
        });
    }
}

