/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.similarity.nodesim;

import java.util.Map;
import java.util.stream.Stream;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.ComputationResult;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.results.MemoryEstimateResult;
import org.neo4j.gds.similarity.SimilarityGraphResult;
import org.neo4j.gds.similarity.SimilarityProc;
import org.neo4j.gds.similarity.SimilarityWriteProc;
import org.neo4j.gds.similarity.SimilarityWriteResult;
import org.neo4j.gds.similarity.nodesim.NodeSimilarity;
import org.neo4j.gds.similarity.nodesim.NodeSimilarityFactory;
import org.neo4j.gds.similarity.nodesim.NodeSimilarityResult;
import org.neo4j.gds.similarity.nodesim.NodeSimilarityWriteConfig;
import org.neo4j.procedure.Description;
import org.neo4j.procedure.Mode;
import org.neo4j.procedure.Name;
import org.neo4j.procedure.Procedure;

@GdsCallable(name="gds.nodeSimilarity.write", description="The Node Similarity algorithm compares a set of nodes based on the nodes they are connected to. Two nodes are considered similar if they share many of the same neighbors. Node Similarity computes pair-wise similarities based on the Jaccard metric.", executionMode=ExecutionMode.WRITE_RELATIONSHIP)
public class NodeSimilarityWriteProc
extends SimilarityWriteProc<NodeSimilarity, NodeSimilarityResult, SimilarityWriteResult, NodeSimilarityWriteConfig> {
    @Procedure(name="gds.nodeSimilarity.write", mode=Mode.WRITE)
    @Description(value="The Node Similarity algorithm compares a set of nodes based on the nodes they are connected to. Two nodes are considered similar if they share many of the same neighbors. Node Similarity computes pair-wise similarities based on the Jaccard metric.")
    public Stream<SimilarityWriteResult> write(@Name(value="graphName") String graphName, @Name(value="configuration", defaultValue="{}") Map<String, Object> configuration) {
        return this.write(this.compute(graphName, configuration));
    }

    @Procedure(value="gds.nodeSimilarity.write.estimate", mode=Mode.READ)
    @Description(value="Returns an estimation of the memory consumption for that procedure.")
    public Stream<MemoryEstimateResult> estimate(@Name(value="graphNameOrConfiguration") Object graphNameOrConfiguration, @Name(value="algoConfiguration") Map<String, Object> algoConfiguration) {
        return this.computeEstimate(graphNameOrConfiguration, algoConfiguration);
    }

    @Override
    public String procedureName() {
        return "NodeSimilarity";
    }

    @Override
    protected SimilarityProc.SimilarityResultBuilder<SimilarityWriteResult> resultBuilder(ComputationResult<NodeSimilarity, NodeSimilarityResult, NodeSimilarityWriteConfig> computationResult) {
        return new SimilarityWriteResult.Builder();
    }

    protected NodeSimilarityWriteConfig newConfig(String username, CypherMapWrapper userInput) {
        return NodeSimilarityWriteConfig.of((CypherMapWrapper)userInput);
    }

    public GraphAlgorithmFactory<NodeSimilarity, NodeSimilarityWriteConfig> algorithmFactory() {
        return new NodeSimilarityFactory();
    }

    protected NodePropertyValues nodeProperties(ComputationResult<NodeSimilarity, NodeSimilarityResult, NodeSimilarityWriteConfig> computationResult) {
        throw new UnsupportedOperationException("NodeSimilarity does not write node properties.");
    }

    @Override
    protected SimilarityGraphResult similarityGraphResult(ComputationResult<NodeSimilarity, NodeSimilarityResult, NodeSimilarityWriteConfig> computationResult) {
        return ((NodeSimilarityResult)computationResult.result()).graphResult();
    }
}

