/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat._55;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UncheckedIOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Clock;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.eclipse.collections.api.factory.Sets;
import org.eclipse.collections.api.set.ImmutableSet;
import org.neo4j.configuration.Config;
import org.neo4j.consistency.checking.ConsistencyFlags;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.dbms.database.readonly.DatabaseReadOnlyChecker;
import org.neo4j.function.ThrowingSupplier;
import org.neo4j.gds.annotation.SuppressForbidden;
import org.neo4j.gds.compat.Neo4jVersion;
import org.neo4j.gds.compat.StorageEngineProxyApi;
import org.neo4j.gds.compat._55.InMemoryMetaDataProviderImpl;
import org.neo4j.gds.compat._55.InMemoryStorageEngineImpl;
import org.neo4j.gds.compat._55.InMemoryStoreVersion;
import org.neo4j.gds.compat._55.InMemoryVersionCheck;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.batchimport.AdditionalInitialIds;
import org.neo4j.internal.batchimport.BatchImporter;
import org.neo4j.internal.batchimport.Configuration;
import org.neo4j.internal.batchimport.IncrementalBatchImporter;
import org.neo4j.internal.batchimport.IndexImporterFactory;
import org.neo4j.internal.batchimport.Monitor;
import org.neo4j.internal.batchimport.ReadBehaviour;
import org.neo4j.internal.batchimport.input.Collector;
import org.neo4j.internal.batchimport.input.Input;
import org.neo4j.internal.batchimport.input.LenientStoreInput;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.ScanOnOpenReadOnlyIdGeneratorFactory;
import org.neo4j.internal.recordstorage.InMemoryStorageCommandReaderFactory55;
import org.neo4j.internal.recordstorage.StoreTokens;
import org.neo4j.internal.schema.IndexConfigCompleter;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.SchemaState;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.Neo4jLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.KernelVersionRepository;
import org.neo4j.kernel.api.index.IndexProvidersAccess;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.locking.Locks;
import org.neo4j.kernel.impl.store.MetaDataStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.StoreFactory;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.kernel.impl.transaction.log.LogTailMetadata;
import org.neo4j.lock.LockService;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.monitoring.DatabaseHealth;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.ConstraintRuleAccessor;
import org.neo4j.storageengine.api.LogFilesInitializer;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.SchemaRule44;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageEngineFactory;
import org.neo4j.storageengine.api.StorageFilesState;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.StoreVersion;
import org.neo4j.storageengine.api.StoreVersionCheck;
import org.neo4j.storageengine.api.StoreVersionIdentifier;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.migration.StoreMigrationParticipant;
import org.neo4j.time.SystemNanoClock;
import org.neo4j.token.DelegatingTokenHolder;
import org.neo4j.token.ReadOnlyTokenCreator;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.NamedToken;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.token.api.TokensLoader;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class InMemoryStorageEngineFactory
implements StorageEngineFactory {
    static final String IN_MEMORY_STORAGE_ENGINE_NAME = "in-memory-55";
    public static final byte ID = 42;

    public InMemoryStorageEngineFactory() {
        StorageEngineProxyApi.requireNeo4jVersion((Neo4jVersion)Neo4jVersion.V_5_5, StorageEngineFactory.class);
    }

    public byte id() {
        return 42;
    }

    public boolean storageExists(FileSystemAbstraction fileSystem, DatabaseLayout databaseLayout) {
        return false;
    }

    public StorageEngine instantiate(FileSystemAbstraction fs, Clock clock, DatabaseLayout databaseLayout, Config config, PageCache pageCache, TokenHolders tokenHolders, SchemaState schemaState, ConstraintRuleAccessor constraintSemantics, IndexConfigCompleter indexConfigCompleter, LockService lockService, IdGeneratorFactory idGeneratorFactory, DatabaseHealth databaseHealth, InternalLogProvider internalLogProvider, InternalLogProvider userLogProvider, RecoveryCleanupWorkCollector recoveryCleanupWorkCollector, LogTailMetadata logTailMetadata, KernelVersionRepository kernelVersionRepository, MemoryTracker memoryTracker, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer) {
        StoreFactory factory = new StoreFactory(databaseLayout, config, idGeneratorFactory, pageCache, pageCacheTracer, fs, internalLogProvider, contextFactory, false, logTailMetadata);
        factory.openNeoStores(new StoreType[]{StoreType.LABEL_TOKEN}).close();
        return new InMemoryStorageEngineImpl(databaseLayout, tokenHolders);
    }

    public Optional<UUID> databaseIdUuid(FileSystemAbstraction fs, DatabaseLayout databaseLayout, PageCache pageCache, CursorContext cursorContext) {
        MetaDataStore.FieldAccess fieldAccess = MetaDataStore.getFieldAccess((PageCache)pageCache, (Path)RecordDatabaseLayout.convert((DatabaseLayout)databaseLayout).metadataStore(), (String)databaseLayout.getDatabaseName(), (CursorContext)cursorContext);
        try {
            return fieldAccess.readDatabaseUUID();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public List<StoreMigrationParticipant> migrationParticipants(FileSystemAbstraction fileSystemAbstraction, Config config, PageCache pageCache, JobScheduler jobScheduler, LogService logService, MemoryTracker memoryTracker, PageCacheTracer pageCacheTracer, CursorContextFactory cursorContextFactory, boolean b) {
        return List.of();
    }

    public DatabaseLayout databaseLayout(Neo4jLayout neo4jLayout, String databaseName) {
        return RecordDatabaseLayout.of((Neo4jLayout)neo4jLayout, (String)databaseName);
    }

    public DatabaseLayout formatSpecificDatabaseLayout(DatabaseLayout plainLayout) {
        return this.databaseLayout(plainLayout.getNeo4jLayout(), plainLayout.getDatabaseName());
    }

    @SuppressForbidden(reason="This is the compat layer and we don't really need to go through the proxy")
    public BatchImporter batchImporter(DatabaseLayout databaseLayout, FileSystemAbstraction fileSystemAbstraction, PageCacheTracer pageCacheTracer, Configuration configuration, LogService logService, PrintStream printStream, boolean b, AdditionalInitialIds additionalInitialIds, Config config, Monitor monitor, JobScheduler jobScheduler, Collector collector, LogFilesInitializer logFilesInitializer, IndexImporterFactory indexImporterFactory, MemoryTracker memoryTracker, CursorContextFactory cursorContextFactory) {
        throw new UnsupportedOperationException("Batch Import into GDS is not supported");
    }

    public Input asBatchImporterInput(DatabaseLayout databaseLayout, FileSystemAbstraction fileSystemAbstraction, PageCache pageCache, PageCacheTracer pageCacheTracer, Config config, MemoryTracker memoryTracker, ReadBehaviour readBehaviour, boolean b, CursorContextFactory cursorContextFactory, LogTailMetadata logTailMetadata) {
        NeoStores neoStores = new StoreFactory(databaseLayout, config, (IdGeneratorFactory)new ScanOnOpenReadOnlyIdGeneratorFactory(), pageCache, pageCacheTracer, fileSystemAbstraction, (InternalLogProvider)NullLogProvider.getInstance(), cursorContextFactory, false, logTailMetadata).openAllNeoStores();
        return new LenientStoreInput(neoStores, readBehaviour.decorateTokenHolders(this.loadReadOnlyTokens(neoStores, true, cursorContextFactory)), true, cursorContextFactory, readBehaviour);
    }

    public long optimalAvailableConsistencyCheckerMemory(FileSystemAbstraction fileSystemAbstraction, DatabaseLayout databaseLayout, Config config, PageCache pageCache) {
        return 0L;
    }

    public String name() {
        return IN_MEMORY_STORAGE_ENGINE_NAME;
    }

    public Set<String> supportedFormats(boolean includeFormatsUnderDevelopment) {
        return Set.of(IN_MEMORY_STORAGE_ENGINE_NAME);
    }

    public boolean supportedFormat(String format, boolean includeFormatsUnderDevelopment) {
        return format.equals(IN_MEMORY_STORAGE_ENGINE_NAME);
    }

    public MetadataProvider transactionMetaDataStore(FileSystemAbstraction fileSystemAbstraction, DatabaseLayout databaseLayout, Config config, PageCache pageCache, DatabaseReadOnlyChecker databaseReadOnlyChecker, CursorContextFactory cursorContextFactory, LogTailMetadata logTailMetadata, PageCacheTracer pageCacheTracer) {
        return new InMemoryMetaDataProviderImpl();
    }

    public StoreVersionCheck versionCheck(FileSystemAbstraction fileSystemAbstraction, DatabaseLayout databaseLayout, Config config, PageCache pageCache, LogService logService, CursorContextFactory cursorContextFactory) {
        return new InMemoryVersionCheck();
    }

    public List<SchemaRule> loadSchemaRules(FileSystemAbstraction fileSystemAbstraction, PageCache pageCache, PageCacheTracer pageCacheTracer, Config config, DatabaseLayout databaseLayout, boolean b, Function<SchemaRule, SchemaRule> function, CursorContextFactory cursorContextFactory) {
        return List.of();
    }

    public List<SchemaRule44> load44SchemaRules(FileSystemAbstraction fileSystemAbstraction, PageCache pageCache, PageCacheTracer pageCacheTracer, Config config, DatabaseLayout databaseLayout, CursorContextFactory cursorContextFactory, LogTailMetadata logTailMetadata) {
        return List.of();
    }

    public TokenHolders loadReadOnlyTokens(FileSystemAbstraction fileSystemAbstraction, DatabaseLayout databaseLayout, Config config, PageCache pageCache, PageCacheTracer pageCacheTracer, boolean lenient, CursorContextFactory cursorContextFactory) {
        StoreFactory factory = new StoreFactory(databaseLayout, config, (IdGeneratorFactory)new ScanOnOpenReadOnlyIdGeneratorFactory(), pageCache, pageCacheTracer, fileSystemAbstraction, (InternalLogProvider)NullLogProvider.getInstance(), cursorContextFactory, false, LogTailMetadata.EMPTY_LOG_TAIL);
        try (NeoStores stores = factory.openNeoStores(new StoreType[]{StoreType.PROPERTY_KEY_TOKEN, StoreType.PROPERTY_KEY_TOKEN_NAME, StoreType.LABEL_TOKEN, StoreType.LABEL_TOKEN_NAME, StoreType.RELATIONSHIP_TYPE_TOKEN, StoreType.RELATIONSHIP_TYPE_TOKEN_NAME});){
            TokenHolders tokenHolders = this.loadReadOnlyTokens(stores, lenient, cursorContextFactory);
            return tokenHolders;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private TokenHolders loadReadOnlyTokens(NeoStores stores, boolean lenient, CursorContextFactory cursorContextFactory) {
        try (CursorContext cursorContext = cursorContextFactory.create("loadReadOnlyTokens");){
            TokenHolders tokenHolders;
            try (CachedStoreCursors storeCursors = new CachedStoreCursors(stores, cursorContext);){
                stores.start(cursorContext);
                TokensLoader loader = lenient ? StoreTokens.allReadableTokens((NeoStores)stores) : StoreTokens.allTokens((NeoStores)stores);
                DelegatingTokenHolder propertyKeys = new DelegatingTokenHolder(ReadOnlyTokenCreator.READ_ONLY, "PropertyKey");
                DelegatingTokenHolder labels = new DelegatingTokenHolder(ReadOnlyTokenCreator.READ_ONLY, "Label");
                DelegatingTokenHolder relationshipTypes = new DelegatingTokenHolder(ReadOnlyTokenCreator.READ_ONLY, "RelationshipType");
                propertyKeys.setInitialTokens(lenient ? InMemoryStorageEngineFactory.unique(loader.getPropertyKeyTokens((StoreCursors)storeCursors)) : loader.getPropertyKeyTokens((StoreCursors)storeCursors));
                labels.setInitialTokens(lenient ? InMemoryStorageEngineFactory.unique(loader.getLabelTokens((StoreCursors)storeCursors)) : loader.getLabelTokens((StoreCursors)storeCursors));
                relationshipTypes.setInitialTokens(lenient ? InMemoryStorageEngineFactory.unique(loader.getRelationshipTypeTokens((StoreCursors)storeCursors)) : loader.getRelationshipTypeTokens((StoreCursors)storeCursors));
                tokenHolders = new TokenHolders((TokenHolder)propertyKeys, (TokenHolder)labels, (TokenHolder)relationshipTypes);
            }
            return tokenHolders;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static List<NamedToken> unique(List<NamedToken> tokens) {
        if (!tokens.isEmpty()) {
            HashSet<String> names = new HashSet<String>(tokens.size());
            int i = 0;
            while (i < tokens.size()) {
                if (names.add(tokens.get(i).name())) {
                    ++i;
                    continue;
                }
                int lastIndex = tokens.size() - 1;
                NamedToken endToken = tokens.remove(lastIndex);
                if (i >= lastIndex) continue;
                tokens.set(i, endToken);
            }
        }
        return tokens;
    }

    public CommandReaderFactory commandReaderFactory() {
        return InMemoryStorageCommandReaderFactory55.INSTANCE;
    }

    public void consistencyCheck(FileSystemAbstraction fileSystem, DatabaseLayout layout, Config config, PageCache pageCache, IndexProviderMap indexProviders, InternalLog log, ConsistencySummaryStatistics summary, int numberOfThreads, long maxOffHeapCachingMemory, OutputStream progressOutput, boolean verbose, ConsistencyFlags flags, CursorContextFactory contextFactory, PageCacheTracer pageCacheTracer, LogTailMetadata logTailMetadata) {
    }

    public ImmutableSet<OpenOption> getStoreOpenOptions(FileSystemAbstraction fs, PageCache pageCache, DatabaseLayout layout, CursorContextFactory contextFactory) {
        return Sets.immutable.empty();
    }

    public StoreId retrieveStoreId(FileSystemAbstraction fs, DatabaseLayout databaseLayout, PageCache pageCache, CursorContext cursorContext) throws IOException {
        return StoreId.retrieveFromStore((FileSystemAbstraction)fs, (DatabaseLayout)databaseLayout, (PageCache)pageCache, (CursorContext)cursorContext);
    }

    public Optional<StoreVersion> versionInformation(StoreVersionIdentifier storeVersionIdentifier) {
        return Optional.of(new InMemoryStoreVersion());
    }

    public void resetMetadata(FileSystemAbstraction fileSystemAbstraction, DatabaseLayout databaseLayout, Config config, PageCache pageCache, CursorContextFactory cursorContextFactory, PageCacheTracer pageCacheTracer, StoreId storeId, UUID externalStoreId) {
        throw new UnsupportedOperationException();
    }

    public IncrementalBatchImporter incrementalBatchImporter(DatabaseLayout databaseLayout, FileSystemAbstraction fileSystem, PageCacheTracer pageCacheTracer, Configuration config, LogService logService, PrintStream progressOutput, boolean verboseProgressOutput, AdditionalInitialIds additionalInitialIds, ThrowingSupplier<LogTailMetadata, IOException> logTailMetadataSupplier, Config dbConfig, Monitor monitor, JobScheduler jobScheduler, Collector badCollector, IndexImporterFactory indexImporterFactory, MemoryTracker memoryTracker, CursorContextFactory contextFactory, IndexProvidersAccess indexProvidersAccess) {
        throw new UnsupportedOperationException();
    }

    public Locks createLocks(Config config, SystemNanoClock clock) {
        return Locks.NO_LOCKS;
    }

    public List<Path> listStorageFiles(FileSystemAbstraction fileSystem, DatabaseLayout databaseLayout) {
        return Collections.emptyList();
    }

    public StorageFilesState checkStoreFileState(FileSystemAbstraction fs, DatabaseLayout databaseLayout, PageCache pageCache) {
        return StorageFilesState.recoveredState();
    }
}

