/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat._57;

import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.counts.CountsStorage;
import org.neo4j.counts.CountsVisitor;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenNotFoundException;

public class InMemoryCountsStoreImpl
implements CountsStorage<CountsAccessor.Updater>,
CountsAccessor {
    private final GraphStore graphStore;
    private final TokenHolders tokenHolders;

    public InMemoryCountsStoreImpl(GraphStore graphStore, TokenHolders tokenHolders) {
        this.graphStore = graphStore;
        this.tokenHolders = tokenHolders;
    }

    public void start(CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) {
    }

    public void checkpoint(FileFlushEvent fileFlushEvent, CursorContext cursorContext) {
    }

    public long nodeCount(int labelId, CursorContext cursorContext) {
        String nodeLabel;
        if (labelId == -1) {
            return this.graphStore.nodeCount();
        }
        try {
            nodeLabel = this.tokenHolders.labelTokens().getTokenById(labelId).name();
        }
        catch (TokenNotFoundException e) {
            throw new RuntimeException(e);
        }
        return this.graphStore.nodes().nodeCount(NodeLabel.of((String)nodeLabel));
    }

    public long relationshipCount(int startLabelId, int typeId, int endLabelId, CursorContext cursorContext) {
        return this.graphStore.relationshipCount();
    }

    public boolean consistencyCheck(ReporterFactory reporterFactory, CursorContextFactory contextFactory, int numThreads, ProgressMonitorFactory progressMonitorFactory) {
        return true;
    }

    public CountsAccessor.Updater apply(long txId, boolean isLast, CursorContext cursorContext) {
        throw new UnsupportedOperationException("Updates are not supported");
    }

    public void close() {
    }

    public void accept(CountsVisitor visitor, CursorContext cursorContext) {
        this.tokenHolders.labelTokens().getAllTokens().forEach(labelToken -> visitor.visitNodeCount(labelToken.id(), this.nodeCount(labelToken.id(), cursorContext)));
        visitor.visitRelationshipCount(-1, -1, -1, this.graphStore.relationshipCount());
    }
}

