/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat._57;

import org.neo4j.internal.recordstorage.AbstractTransactionIdStore;
import org.neo4j.io.pagecache.context.TransactionIdSnapshot;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.storageengine.api.ClosedTransactionMetadata;
import org.neo4j.storageengine.api.TransactionId;

public class InMemoryTransactionIdStoreImpl
extends AbstractTransactionIdStore {
    protected void initLastCommittedAndClosedTransactionId(long previouslyCommittedTxId, int checksum, long previouslyCommittedTxCommitTimestamp, long previouslyCommittedTxLogByteOffset, long previouslyCommittedTxLogVersion) {
        this.setLastCommittedAndClosedTransactionId(previouslyCommittedTxId, checksum, previouslyCommittedTxCommitTimestamp, -1L, previouslyCommittedTxLogByteOffset, previouslyCommittedTxLogVersion);
    }

    public ClosedTransactionMetadata getLastClosedTransaction() {
        long[] metaData = this.closedTransactionId.get();
        return new ClosedTransactionMetadata(metaData[0], new LogPosition(metaData[1], metaData[2]), (int)metaData[3], metaData[4], metaData[5]);
    }

    public TransactionIdSnapshot getClosedTransactionSnapshot() {
        return new TransactionIdSnapshot(this.getLastClosedTransactionId());
    }

    protected TransactionId transactionId(long transactionId, int checksum, long commitTimestamp) {
        return new TransactionId(transactionId, checksum, commitTimestamp, -1L);
    }

    public void transactionCommitted(long transactionId, int checksum, long commitTimestamp, long consensusIndex) {
    }

    public void setLastCommittedAndClosedTransactionId(long transactionId, int checksum, long commitTimestamp, long consensusIndex, long byteOffset, long logVersion) {
    }

    public void transactionClosed(long transactionId, long logVersion, long byteOffset, int checksum, long commitTimestamp, long consensusIndex) {
        this.closedTransactionId.offer(transactionId, new long[]{logVersion, byteOffset, checksum, commitTimestamp, consensusIndex});
    }

    public void resetLastClosedTransaction(long transactionId, long logVersion, long byteOffset, int checksum, long commitTimestamp, long consensusIndex) {
        this.closedTransactionId.set(transactionId, new long[]{logVersion, byteOffset, checksum, commitTimestamp, consensusIndex});
    }
}

