/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat._57;

import org.neo4j.common.Edition;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.compat.AbstractInMemoryNodeCursor;
import org.neo4j.gds.compat.AbstractInMemoryNodePropertyCursor;
import org.neo4j.gds.compat.AbstractInMemoryRelationshipPropertyCursor;
import org.neo4j.gds.compat.AbstractInMemoryRelationshipTraversalCursor;
import org.neo4j.gds.compat.GdsDatabaseManagementServiceBuilder;
import org.neo4j.gds.compat.GraphDatabaseApiProxy;
import org.neo4j.gds.compat.StorageEngineProxyApi;
import org.neo4j.gds.compat._57.InMemoryCommandCreationContextImpl;
import org.neo4j.gds.compat._57.InMemoryNodeCursor;
import org.neo4j.gds.compat._57.InMemoryNodePropertyCursor;
import org.neo4j.gds.compat._57.InMemoryRelationshipPropertyCursor;
import org.neo4j.gds.compat._57.InMemoryRelationshipScanCursor;
import org.neo4j.gds.compat._57.InMemoryRelationshipTraversalCursor;
import org.neo4j.gds.compat._57.InMemoryStorageEngineImpl;
import org.neo4j.gds.core.cypher.CypherGraphStore;
import org.neo4j.graphdb.Direction;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.internal.recordstorage.AbstractInMemoryRelationshipScanCursor;
import org.neo4j.internal.recordstorage.InMemoryStorageReader57;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.RelationshipSelection;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageEntityCursor;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipTraversalCursor;
import org.neo4j.token.TokenHolders;

public class StorageEngineProxyImpl
implements StorageEngineProxyApi {
    public CommandCreationContext inMemoryCommandCreationContext() {
        return new InMemoryCommandCreationContextImpl();
    }

    public void initRelationshipTraversalCursorForRelType(StorageRelationshipTraversalCursor cursor, long sourceNodeId, int relTypeToken) {
        RelationshipSelection relationshipSelection = RelationshipSelection.selection((int)relTypeToken, (Direction)Direction.OUTGOING);
        cursor.init(sourceNodeId, -1L, relationshipSelection);
    }

    public StorageReader inMemoryStorageReader(CypherGraphStore graphStore, TokenHolders tokenHolders, CountsAccessor counts) {
        return new InMemoryStorageReader57(graphStore, tokenHolders, counts);
    }

    public StorageEngine createInMemoryStorageEngine(DatabaseLayout databaseLayout, TokenHolders tokenHolders) {
        return new InMemoryStorageEngineImpl(databaseLayout, tokenHolders);
    }

    public void createInMemoryDatabase(DatabaseManagementService dbms, String dbName, Config config) {
        config.set(GraphDatabaseSettings.db_format, (Object)"in-memory-57");
        dbms.createDatabase(dbName, (Configuration)config);
    }

    public GraphDatabaseService startAndGetInMemoryDatabase(DatabaseManagementService dbms, String dbName) {
        dbms.startDatabase(dbName);
        return dbms.database(dbName);
    }

    public GdsDatabaseManagementServiceBuilder setSkipDefaultIndexesOnCreationSetting(GdsDatabaseManagementServiceBuilder dbmsBuilder) {
        return dbmsBuilder.setConfig(GraphDatabaseInternalSettings.skip_default_indexes_on_creation, (Object)true);
    }

    public AbstractInMemoryNodeCursor inMemoryNodeCursor(CypherGraphStore graphStore, TokenHolders tokenHolders) {
        return new InMemoryNodeCursor((GraphStore)graphStore, tokenHolders);
    }

    public AbstractInMemoryNodePropertyCursor inMemoryNodePropertyCursor(CypherGraphStore graphStore, TokenHolders tokenHolders) {
        return new InMemoryNodePropertyCursor(graphStore, tokenHolders);
    }

    public AbstractInMemoryRelationshipTraversalCursor inMemoryRelationshipTraversalCursor(CypherGraphStore graphStore, TokenHolders tokenHolders) {
        return new InMemoryRelationshipTraversalCursor(graphStore, tokenHolders);
    }

    public AbstractInMemoryRelationshipScanCursor inMemoryRelationshipScanCursor(CypherGraphStore graphStore, TokenHolders tokenHolders) {
        return new InMemoryRelationshipScanCursor(graphStore, tokenHolders);
    }

    public AbstractInMemoryRelationshipPropertyCursor inMemoryRelationshipPropertyCursor(CypherGraphStore graphStore, TokenHolders tokenHolders) {
        return new InMemoryRelationshipPropertyCursor(graphStore, tokenHolders);
    }

    public void properties(StorageEntityCursor storageCursor, StoragePropertyCursor propertyCursor, int[] propertySelection) {
        PropertySelection selection = propertySelection.length == 0 ? PropertySelection.ALL_PROPERTIES : PropertySelection.selection((int[])propertySelection);
        storageCursor.properties(propertyCursor, selection);
    }

    public Edition dbmsEdition(GraphDatabaseService databaseService) {
        return GraphDatabaseApiProxy.dbmsInfo((GraphDatabaseService)databaseService).edition;
    }
}

