/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat._58;

import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import org.neo4j.gds.compat._58.InMemoryTransactionIdStoreImpl;
import org.neo4j.internal.recordstorage.InMemoryLogVersionRepository58;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.TransactionIdSnapshot;
import org.neo4j.storageengine.api.ClosedTransactionMetadata;
import org.neo4j.storageengine.api.ExternalStoreId;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionId;

public class InMemoryMetaDataProviderImpl
implements MetadataProvider {
    private final ExternalStoreId externalStoreId;
    private final InMemoryLogVersionRepository58 logVersionRepository = new InMemoryLogVersionRepository58();
    private final InMemoryTransactionIdStoreImpl transactionIdStore;

    InMemoryMetaDataProviderImpl() {
        this.externalStoreId = new ExternalStoreId(UUID.randomUUID());
        this.transactionIdStore = new InMemoryTransactionIdStoreImpl();
    }

    public ExternalStoreId getExternalStoreId() {
        return this.externalStoreId;
    }

    public ClosedTransactionMetadata getLastClosedTransaction() {
        return this.transactionIdStore.getLastClosedTransaction();
    }

    public void setCurrentLogVersion(long version) {
        this.logVersionRepository.setCurrentLogVersion(version);
    }

    public long incrementAndGetVersion() {
        return this.logVersionRepository.incrementAndGetVersion();
    }

    public void setCheckpointLogVersion(long version) {
        this.logVersionRepository.setCheckpointLogVersion(version);
    }

    public long incrementAndGetCheckpointLogVersion() {
        return this.logVersionRepository.incrementAndGetCheckpointLogVersion();
    }

    public void transactionCommitted(long transactionId, int checksum, long commitTimestamp, long consensusIndex) {
        this.transactionIdStore.transactionCommitted(transactionId, checksum, commitTimestamp, consensusIndex);
    }

    public void setLastCommittedAndClosedTransactionId(long transactionId, int checksum, long commitTimestamp, long consensusIndex, long byteOffset, long logVersion) {
        this.transactionIdStore.setLastCommittedAndClosedTransactionId(transactionId, checksum, commitTimestamp, consensusIndex, byteOffset, logVersion);
    }

    public void transactionClosed(long transactionId, long logVersion, long byteOffset, int checksum, long commitTimestamp, long consensusIndex) {
        this.transactionIdStore.transactionClosed(transactionId, logVersion, byteOffset, checksum, commitTimestamp, consensusIndex);
    }

    public void resetLastClosedTransaction(long transactionId, long logVersion, long byteOffset, int checksum, long commitTimestamp, long consensusIndex) {
        this.transactionIdStore.resetLastClosedTransaction(transactionId, logVersion, byteOffset, checksum, commitTimestamp, consensusIndex);
    }

    public TransactionIdSnapshot getClosedTransactionSnapshot() {
        return new TransactionIdSnapshot(this.getLastClosedTransactionId());
    }

    public void regenerateMetadata(StoreId storeId, UUID externalStoreUUID, CursorContext cursorContext) {
    }

    public StoreId getStoreId() {
        return StoreId.UNKNOWN;
    }

    public void close() throws IOException {
    }

    public long getCurrentLogVersion() {
        return this.logVersionRepository.getCurrentLogVersion();
    }

    public long getCheckpointLogVersion() {
        return this.logVersionRepository.getCheckpointLogVersion();
    }

    public long nextCommittingTransactionId() {
        return this.transactionIdStore.nextCommittingTransactionId();
    }

    public long committingTransactionId() {
        return this.transactionIdStore.committingTransactionId();
    }

    public long getLastCommittedTransactionId() {
        return this.transactionIdStore.getLastCommittedTransactionId();
    }

    public TransactionId getLastCommittedTransaction() {
        return this.transactionIdStore.getLastCommittedTransaction();
    }

    public long getLastClosedTransactionId() {
        return this.transactionIdStore.getLastClosedTransactionId();
    }

    public Optional<UUID> getDatabaseIdUuid(CursorContext cursorTracer) {
        throw new IllegalStateException("Not supported");
    }

    public void setDatabaseIdUuid(UUID uuid, CursorContext cursorContext) {
        throw new IllegalStateException("Not supported");
    }
}

