/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.compat._58;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.exceptions.KernelException;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.compat.TokenManager;
import org.neo4j.gds.compat._58.InMemoryCommandCreationContextImpl;
import org.neo4j.gds.compat._58.InMemoryCountsStoreImpl;
import org.neo4j.gds.compat._58.InMemoryMetaDataProviderImpl;
import org.neo4j.gds.compat._58.InMemoryStorageLocksImpl;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.core.cypher.CypherGraphStore;
import org.neo4j.gds.core.loading.GraphStoreCatalog;
import org.neo4j.gds.storageengine.InMemoryDatabaseCreationCatalog;
import org.neo4j.gds.storageengine.InMemoryTransactionStateVisitor;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.internal.diagnostics.DiagnosticsLogger;
import org.neo4j.internal.recordstorage.InMemoryStorageReader58;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.tracing.DatabaseFlushEvent;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.store.stats.StoreEntityCounters;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.lock.LockGroup;
import org.neo4j.lock.LockService;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.logging.InternalLog;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.CommandBatchToApply;
import org.neo4j.storageengine.api.CommandCreationContext;
import org.neo4j.storageengine.api.CommandStream;
import org.neo4j.storageengine.api.IndexUpdateListener;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.StorageEngine;
import org.neo4j.storageengine.api.StorageLocks;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StoreFileMetadata;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.api.enrichment.Enrichment;
import org.neo4j.storageengine.api.enrichment.EnrichmentCommand;
import org.neo4j.storageengine.api.txstate.ReadableTransactionState;
import org.neo4j.storageengine.api.txstate.TxStateVisitor;
import org.neo4j.token.TokenHolders;

public final class InMemoryStorageEngineImpl
implements StorageEngine {
    private final MetadataProvider metadataProvider;
    private final CypherGraphStore graphStore;
    private final DatabaseLayout databaseLayout;
    private final InMemoryTransactionStateVisitor txStateVisitor;
    private final CommandCreationContext commandCreationContext;
    private final TokenManager tokenManager;
    private final InMemoryCountsStoreImpl countsStore;
    private static final StorageEngineIndexingBehaviour INDEXING_BEHAVIOUR = new StorageEngineIndexingBehaviour(){

        public boolean useNodeIdsInRelationshipTokenIndex() {
            return false;
        }

        public boolean requireCoordinationLocks() {
            return false;
        }

        public int nodesPerPage() {
            return 0;
        }

        public int relationshipsPerPage() {
            return 0;
        }
    };

    InMemoryStorageEngineImpl(DatabaseLayout databaseLayout, TokenHolders tokenHolders) {
        this.databaseLayout = databaseLayout;
        this.graphStore = InMemoryStorageEngineImpl.getGraphStoreFromCatalog(databaseLayout.getDatabaseName());
        this.txStateVisitor = new InMemoryTransactionStateVisitor(this.graphStore, tokenHolders);
        this.commandCreationContext = new InMemoryCommandCreationContextImpl();
        this.tokenManager = new TokenManager(tokenHolders, this.txStateVisitor, this.graphStore, this.commandCreationContext);
        this.graphStore.initialize(tokenHolders);
        this.countsStore = new InMemoryCountsStoreImpl((GraphStore)this.graphStore, tokenHolders);
        this.metadataProvider = new InMemoryMetaDataProviderImpl();
    }

    private static CypherGraphStore getGraphStoreFromCatalog(String databaseName) {
        String graphName = InMemoryDatabaseCreationCatalog.getRegisteredDbCreationGraphName((String)databaseName);
        return (CypherGraphStore)GraphStoreCatalog.getAllGraphStores().filter(graphStoreWithUserNameAndConfig -> graphStoreWithUserNameAndConfig.config().graphName().equals(graphName)).findFirst().orElseThrow(() -> new IllegalArgumentException(StringFormatting.formatWithLocale((String)"No graph with name `%s` was found in GraphStoreCatalog. Available graph names are %s", (Object[])new Object[]{graphName, GraphStoreCatalog.getAllGraphStores().map(GraphStoreCatalog.GraphStoreWithUserNameAndConfig::config).map(GraphProjectConfig::graphName).collect(Collectors.toList())}))).graphStore();
    }

    public StoreEntityCounters storeEntityCounters() {
        return new StoreEntityCounters(){

            public long nodes() {
                return InMemoryStorageEngineImpl.this.graphStore.nodeCount();
            }

            public long relationships() {
                return InMemoryStorageEngineImpl.this.graphStore.relationshipCount();
            }

            public long properties() {
                return InMemoryStorageEngineImpl.this.graphStore.nodePropertyKeys().size() + InMemoryStorageEngineImpl.this.graphStore.relationshipPropertyKeys().size();
            }

            public long relationshipTypes() {
                return InMemoryStorageEngineImpl.this.graphStore.relationshipTypes().size();
            }

            public long allNodesCountStore(CursorContext cursorContext) {
                return InMemoryStorageEngineImpl.this.graphStore.nodeCount();
            }

            public long allRelationshipsCountStore(CursorContext cursorContext) {
                return InMemoryStorageEngineImpl.this.graphStore.relationshipCount();
            }
        };
    }

    public void preAllocateStoreFilesForCommands(CommandBatchToApply commandBatchToApply, TransactionApplicationMode transactionApplicationMode) {
    }

    public StoreCursors createStorageCursors(CursorContext initialContext) {
        return StoreCursors.NULL;
    }

    public StorageLocks createStorageLocks(ResourceLocker locker) {
        return new InMemoryStorageLocksImpl(locker);
    }

    public List<StorageCommand> createCommands(ReadableTransactionState state, StorageReader storageReader, CommandCreationContext creationContext, LockTracer lockTracer, TxStateVisitor.Decorator additionalTxStateVisitor, CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) throws KernelException {
        state.accept((TxStateVisitor)this.txStateVisitor);
        return List.of();
    }

    public void dumpDiagnostics(InternalLog internalLog, DiagnosticsLogger diagnosticsLogger) {
    }

    public List<StorageCommand> createUpgradeCommands(KernelVersion versionToUpgradeFrom, KernelVersion versionToUpgradeTo) {
        return List.of();
    }

    public EnrichmentCommand createEnrichmentCommand(KernelVersion kernelVersion, Enrichment enrichment) {
        throw new UnsupportedOperationException();
    }

    public StoreId retrieveStoreId() {
        return this.metadataProvider.getStoreId();
    }

    public StorageEngineIndexingBehaviour indexingBehaviour() {
        return INDEXING_BEHAVIOUR;
    }

    public StorageReader newReader() {
        return new InMemoryStorageReader58(this.graphStore, this.tokenManager.tokenHolders(), this.countsStore);
    }

    public void addIndexUpdateListener(IndexUpdateListener listener) {
    }

    public void apply(CommandBatchToApply batch, TransactionApplicationMode mode) {
    }

    public void init() {
    }

    public void start() {
    }

    public void stop() {
        this.shutdown();
    }

    public void shutdown() {
        InMemoryDatabaseCreationCatalog.removeDatabaseEntry((String)this.databaseLayout.getDatabaseName());
    }

    public void listStorageFiles(Collection<StoreFileMetadata> atomic, Collection<StoreFileMetadata> replayable) {
    }

    public Lifecycle schemaAndTokensLifecycle() {
        return new LifecycleAdapter(){

            public void init() {
            }
        };
    }

    public CountsAccessor countsAccessor() {
        return this.countsStore;
    }

    public MetadataProvider metadataProvider() {
        return this.metadataProvider;
    }

    public CommandCreationContext newCommandCreationContext() {
        return this.commandCreationContext;
    }

    public void lockRecoveryCommands(CommandStream commands, LockService lockService, LockGroup lockGroup, TransactionApplicationMode mode) {
    }

    public void rollback(ReadableTransactionState txState, CursorContext cursorContext) {
    }

    public void checkpoint(DatabaseFlushEvent flushEvent, CursorContext cursorContext) {
    }
}

