/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.impl.set.immutable.primitive.ImmutableIntSetFactoryImpl;
import org.neo4j.common.EntityType;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.counts.CountsAccessor;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.compat._58.InMemoryNodeCursor;
import org.neo4j.gds.compat._58.InMemoryPropertyCursor;
import org.neo4j.gds.compat._58.InMemoryRelationshipScanCursor;
import org.neo4j.gds.compat._58.InMemoryRelationshipTraversalCursor;
import org.neo4j.gds.core.cypher.CypherGraphStore;
import org.neo4j.internal.recordstorage.AbstractInMemoryAllRelationshipScan;
import org.neo4j.internal.recordstorage.AbstractInMemoryRelationshipScanCursor;
import org.neo4j.internal.recordstorage.InMemoryNodeScan;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.AllNodeScan;
import org.neo4j.storageengine.api.AllRelationshipsScan;
import org.neo4j.storageengine.api.StorageNodeCursor;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.StorageRelationshipScanCursor;
import org.neo4j.storageengine.api.StorageRelationshipTraversalCursor;
import org.neo4j.storageengine.api.StorageSchemaReader;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.token.TokenHolders;

public class InMemoryStorageReader58
implements StorageReader {
    protected final CypherGraphStore graphStore;
    protected final TokenHolders tokenHolders;
    protected final CountsAccessor counts;
    private final Map<Class<?>, Object> dependantState;
    private boolean closed;

    public InMemoryStorageReader58(CypherGraphStore graphStore, TokenHolders tokenHolders, CountsAccessor counts) {
        this.graphStore = graphStore;
        this.tokenHolders = tokenHolders;
        this.counts = counts;
        this.dependantState = new ConcurrentHashMap();
    }

    public Collection<IndexBackedConstraintDescriptor> uniquenessConstraintsGetRelated(long[] changedLabels, long[] unchangedLabels, int[] propertyKeyIds, boolean propertyKeyListIsComplete, EntityType entityType) {
        return Collections.emptyList();
    }

    public long relationshipsGetCount(CursorContext cursorTracer) {
        return this.graphStore.relationshipCount();
    }

    public boolean nodeExists(long id, StoreCursors storeCursors) {
        long originalId = this.graphStore.nodes().toOriginalNodeId(id);
        return this.graphStore.nodes().contains(originalId);
    }

    public boolean relationshipExists(long id, StoreCursors storeCursors) {
        return true;
    }

    public StorageNodeCursor allocateNodeCursor(CursorContext cursorContext, StoreCursors storeCursors) {
        return new InMemoryNodeCursor((GraphStore)this.graphStore, this.tokenHolders);
    }

    public StoragePropertyCursor allocatePropertyCursor(CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        return new InMemoryPropertyCursor(this.graphStore, this.tokenHolders);
    }

    public StorageRelationshipTraversalCursor allocateRelationshipTraversalCursor(CursorContext cursorContext, StoreCursors storeCursors) {
        return new InMemoryRelationshipTraversalCursor(this.graphStore, this.tokenHolders);
    }

    public StorageRelationshipScanCursor allocateRelationshipScanCursor(CursorContext cursorContext, StoreCursors storeCursors) {
        return new InMemoryRelationshipScanCursor(this.graphStore, this.tokenHolders);
    }

    public IndexDescriptor indexGetForSchemaAndType(SchemaDescriptor descriptor, IndexType type) {
        return null;
    }

    public AllRelationshipsScan allRelationshipScan() {
        return new AbstractInMemoryAllRelationshipScan(){

            boolean scanRange(AbstractInMemoryRelationshipScanCursor cursor, long start, long stopInclusive) {
                return cursor.scanRange(start, stopInclusive);
            }

            public boolean scanBatch(long sizeHint, AbstractInMemoryRelationshipScanCursor cursor) {
                return super.scanBatch(sizeHint, (PrimitiveRecord)cursor);
            }
        };
    }

    public Iterator<IndexDescriptor> indexGetForSchema(SchemaDescriptor descriptor) {
        return Collections.emptyIterator();
    }

    public Iterator<IndexDescriptor> indexesGetForLabel(int labelId) {
        return Collections.emptyIterator();
    }

    public Iterator<IndexDescriptor> indexesGetForRelationshipType(int relationshipType) {
        return Collections.emptyIterator();
    }

    public IndexDescriptor indexGetForName(String name) {
        return null;
    }

    public ConstraintDescriptor constraintGetForName(String name) {
        return null;
    }

    public boolean indexExists(IndexDescriptor index) {
        return false;
    }

    public Iterator<IndexDescriptor> indexesGetAll() {
        return Collections.emptyIterator();
    }

    public Collection<IndexDescriptor> valueIndexesGetRelated(long[] tokens, int propertyKeyId, EntityType entityType) {
        return this.valueIndexesGetRelated(tokens, new int[]{propertyKeyId}, entityType);
    }

    public Collection<IndexDescriptor> valueIndexesGetRelated(long[] tokens, int[] propertyKeyIds, EntityType entityType) {
        return Collections.emptyList();
    }

    public Collection<IndexBackedConstraintDescriptor> uniquenessConstraintsGetRelated(long[] labels, int propertyKeyId, EntityType entityType) {
        return Collections.emptyList();
    }

    public Collection<IndexBackedConstraintDescriptor> uniquenessConstraintsGetRelated(long[] tokens, int[] propertyKeyIds, EntityType entityType) {
        return Collections.emptyList();
    }

    public boolean hasRelatedSchema(long[] labels, int propertyKey, EntityType entityType) {
        return false;
    }

    public boolean hasRelatedSchema(int label, EntityType entityType) {
        return false;
    }

    public Iterator<ConstraintDescriptor> constraintsGetForSchema(SchemaDescriptor descriptor) {
        return Collections.emptyIterator();
    }

    public boolean constraintExists(ConstraintDescriptor descriptor) {
        return false;
    }

    public Iterator<ConstraintDescriptor> constraintsGetForLabel(int labelId) {
        return Collections.emptyIterator();
    }

    public Iterator<ConstraintDescriptor> constraintsGetForRelationshipType(int typeId) {
        return Collections.emptyIterator();
    }

    public Iterator<ConstraintDescriptor> constraintsGetAll() {
        return Collections.emptyIterator();
    }

    public IntSet constraintsGetPropertyTokensForLogicalKey(int token, EntityType entityType) {
        return ImmutableIntSetFactoryImpl.INSTANCE.empty();
    }

    public Long indexGetOwningUniquenessConstraintId(IndexDescriptor index) {
        return null;
    }

    public long countsForNode(int labelId, CursorContext cursorContext) {
        return this.counts.nodeCount(labelId, cursorContext);
    }

    public long countsForRelationship(int startLabelId, int typeId, int endLabelId, CursorContext cursorContext) {
        return this.counts.relationshipCount(startLabelId, typeId, endLabelId, cursorContext);
    }

    public long nodesGetCount(CursorContext cursorContext) {
        return this.graphStore.nodeCount();
    }

    public int labelCount() {
        return this.graphStore.nodes().availableNodeLabels().size();
    }

    public int propertyKeyCount() {
        int nodePropertyCount = this.graphStore.schema().nodeSchema().allProperties().size();
        int relPropertyCount = this.graphStore.schema().relationshipSchema().allProperties().size();
        return nodePropertyCount + relPropertyCount;
    }

    public int relationshipTypeCount() {
        return this.graphStore.schema().relationshipSchema().availableTypes().size();
    }

    public <T> T getOrCreateSchemaDependantState(Class<T> type, Function<StorageReader, T> factory) {
        return type.cast(this.dependantState.computeIfAbsent(type, key -> factory.apply(this)));
    }

    public AllNodeScan allNodeScan() {
        return new InMemoryNodeScan();
    }

    public void close() {
        assert (!this.closed);
        this.closed = true;
    }

    public StorageSchemaReader schemaSnapshot() {
        return this;
    }

    public TokenNameLookup tokenNameLookup() {
        return this.tokenHolders;
    }
}

