/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.utils;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.intellij.lang.annotations.PrintFormat;

public final class StringFormatting {
    private StringFormatting() {
    }

    public static String formatWithLocale(@PrintFormat String template, Object ... inputs) {
        return String.format(Locale.ENGLISH, template, inputs);
    }

    public static String formatNumber(long number) {
        DecimalFormat formatter = (DecimalFormat)NumberFormat.getInstance(Locale.ENGLISH);
        DecimalFormatSymbols symbols = formatter.getDecimalFormatSymbols();
        symbols.setGroupingSeparator('_');
        formatter.setDecimalFormatSymbols(symbols);
        return formatter.format(number);
    }

    public static String formatNumber(int number) {
        return StringFormatting.formatNumber((long)number);
    }

    public static String toLowerCaseWithLocale(String string) {
        return string.toLowerCase(Locale.ENGLISH);
    }

    public static String toUpperCaseWithLocale(String string) {
        return string.toUpperCase(Locale.ENGLISH);
    }

    public static boolean isEmpty(String string) {
        return StringUtils.isEmpty((CharSequence)string);
    }
}

