/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.utils;

import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class StringJoining {
    private StringJoining() {
    }

    public static String join(Stream<String> alternatives) {
        return StringJoining.join(alternatives.collect(Collectors.toList()));
    }

    public static String join(Stream<String> alternatives, CharSequence delimiter) {
        return StringJoining.join(alternatives.collect(Collectors.toList()), delimiter);
    }

    public static String join(Collection<String> alternatives) {
        if (alternatives.isEmpty()) {
            return "[]";
        }
        return StringJoining.join(alternatives, (CharSequence)"', '", (CharSequence)"['", (CharSequence)"']");
    }

    public static String join(Collection<String> alternatives, CharSequence delimiter) {
        return StringJoining.joinInGivenOrder(alternatives.stream().sorted(), delimiter);
    }

    public static String joinInGivenOrder(Stream<String> alternatives, CharSequence delimiter) {
        return alternatives.collect(Collectors.joining(delimiter));
    }

    public static String join(Collection<String> alternatives, CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return StringJoining.join(alternatives.stream(), delimiter, prefix, suffix);
    }

    public static String join(Stream<String> alternatives, CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return alternatives.sorted().collect(Collectors.joining(delimiter, prefix, suffix));
    }

    public static String joinVerbose(Collection<String> alternatives) {
        if (alternatives.size() == 1) {
            return StringJoining.join(alternatives, (CharSequence)", ");
        }
        if (alternatives.size() == 2) {
            return StringJoining.join(alternatives, (CharSequence)" and ");
        }
        return StringJoining.joinVerbose(List.of(StringJoining.join(alternatives.stream().limit(alternatives.size() - 1), (CharSequence)", "), alternatives.stream().skip(alternatives.size() - 1).findFirst().orElseThrow(() -> new IllegalStateException("No alternatives found."))));
    }
}

