/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Condition;
import org.assertj.core.api.HamcrestCondition;
import org.hamcrest.Matcher;
import org.intellij.lang.annotations.Language;
import org.junit.jupiter.api.AfterEach;
import org.neo4j.gds.BaseTest;
import org.neo4j.gds.GdsCypher;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.compat.GraphDatabaseApiProxy;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.core.ExceptionMessageMatcher;
import org.neo4j.gds.core.Username;
import org.neo4j.gds.core.loading.GraphStoreCatalog;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Result;
import org.neo4j.kernel.database.NamedDatabaseId;

public class BaseProcTest
extends BaseTest {
    @AfterEach
    void cleanupGraphStoreCatalog() {
        GraphStoreCatalog.removeAllLoadedGraphs();
    }

    protected void registerFunctions(Class<?> ... functionClasses) throws Exception {
        GraphDatabaseApiProxy.registerFunctions((GraphDatabaseService)this.db, (Class[])functionClasses);
    }

    protected void registerAggregationFunctions(Class<?> ... functionClasses) throws Exception {
        GraphDatabaseApiProxy.registerAggregationFunctions((GraphDatabaseService)this.db, (Class[])functionClasses);
    }

    protected void registerFunctions(GraphDatabaseService db, Class<?> ... functionClasses) throws Exception {
        GraphDatabaseApiProxy.registerFunctions((GraphDatabaseService)db, (Class[])functionClasses);
    }

    protected void registerProcedures(Class<?> ... procedureClasses) throws Exception {
        this.registerProcedures((GraphDatabaseService)this.db, procedureClasses);
    }

    protected void registerProcedures(GraphDatabaseService db, Class<?> ... procedureClasses) throws Exception {
        GraphDatabaseApiProxy.registerProcedures((GraphDatabaseService)db, (Class[])procedureClasses);
    }

    <T> T resolveDependency(Class<T> dependency) {
        return (T)GraphDatabaseApiProxy.resolveDependency((GraphDatabaseService)this.db, dependency);
    }

    protected String getUsername() {
        return Username.EMPTY_USERNAME.username();
    }

    protected void assertError(@Language(value="Cypher") String query, String messageSubstring) {
        this.assertError(query, Collections.emptyMap(), messageSubstring);
    }

    protected void assertError(@Language(value="Cypher") String query, Map<String, Object> queryParameters, String messageSubstring) {
        this.assertError(query, queryParameters, (Matcher<Throwable>)ExceptionMessageMatcher.containsMessage((String)messageSubstring));
    }

    protected void assertErrorRegex(@Language(value="Cypher") String query, String regex) {
        this.assertErrorRegex(query, Collections.emptyMap(), regex);
    }

    private void assertErrorRegex(@Language(value="Cypher") String query, Map<String, Object> queryParameters, String regex) {
        this.assertError(query, queryParameters, (Matcher<Throwable>)ExceptionMessageMatcher.containsMessageRegex((String)regex));
    }

    private void assertError(@Language(value="Cypher") String query, Map<String, Object> queryParameters, Matcher<Throwable> matcher) {
        try {
            this.runQueryWithResultConsumer(query, queryParameters, BaseProcTest::consume);
            org.junit.jupiter.api.Assertions.fail((String)StringFormatting.formatWithLocale((String)"Expected an exception to be thrown by query:\n%s", (Object[])new Object[]{query}));
        }
        catch (Throwable e) {
            Assertions.assertThat((Throwable)e).has((Condition)new HamcrestCondition(matcher));
        }
    }

    protected void assertUserInput(Result.ResultRow row, String key, Object expected) {
        Map<String, Object> configMap = this.extractUserInput(row);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)configMap.containsKey(key), (String)StringFormatting.formatWithLocale((String)"Key %s is not present in config", (Object[])new Object[]{key}));
        org.junit.jupiter.api.Assertions.assertEquals((Object)expected, (Object)configMap.get(key));
    }

    private Map<String, Object> extractUserInput(Result.ResultRow row) {
        return (Map)row.get("configuration");
    }

    protected void loadCompleteGraph(String graphName) {
        this.loadCompleteGraph(graphName, Orientation.NATURAL);
    }

    protected void loadCompleteGraph(String graphName, Orientation orientation) {
        String createQuery = GdsCypher.call(graphName).graphProject().loadEverything(orientation).yields(new String[0]);
        this.runQuery(createQuery);
    }

    protected void assertGraphExists(String graphName) {
        Set<Graph> graphs = this.getLoadedGraphs(graphName);
        org.junit.jupiter.api.Assertions.assertEquals((int)1, (int)graphs.size());
    }

    protected void assertGraphDoesNotExist(String graphName) {
        Set<Graph> graphs = this.getLoadedGraphs(graphName);
        org.junit.jupiter.api.Assertions.assertTrue((boolean)graphs.isEmpty());
    }

    protected Graph findLoadedGraph(String graphName) {
        return GraphStoreCatalog.getGraphStores((String)"", (NamedDatabaseId)this.db.databaseId()).entrySet().stream().filter(e -> ((GraphProjectConfig)e.getKey()).graphName().equals(graphName)).map(e -> ((GraphStore)e.getValue()).getUnion()).findFirst().orElseThrow(() -> new RuntimeException(StringFormatting.formatWithLocale((String)"Graph %s not found.", (Object[])new Object[]{graphName})));
    }

    private Set<Graph> getLoadedGraphs(String graphName) {
        return GraphStoreCatalog.getGraphStores((String)"", (NamedDatabaseId)this.db.databaseId()).entrySet().stream().filter(e -> ((GraphProjectConfig)e.getKey()).graphName().equals(graphName)).map(e -> ((GraphStore)e.getValue()).getUnion()).collect(Collectors.toSet());
    }

    private static void consume(ResourceIterator<Map<String, Object>> result) {
        while (result.hasNext()) {
            result.next();
        }
        result.close();
    }
}

