/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.assertj.core.api.Assertions;
import org.intellij.lang.annotations.Language;
import org.neo4j.gds.QueryRunner;
import org.neo4j.gds.TestSupport;
import org.neo4j.gds.core.Settings;
import org.neo4j.gds.extension.IdFunction;
import org.neo4j.gds.extension.Inject;
import org.neo4j.gds.extension.Neo4jGraphExtension;
import org.neo4j.gds.extension.NodeFunction;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.Result;
import org.neo4j.graphdb.Transaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.test.TestDatabaseManagementServiceBuilder;
import org.neo4j.test.extension.ExtensionCallback;
import org.neo4j.test.extension.ImpermanentDbmsExtension;

@ImpermanentDbmsExtension(configurationCallback="configuration")
@Neo4jGraphExtension
public abstract class BaseTest {
    protected static final String DEFAULT_GRAPH_NAME = "graph";
    @Inject
    public GraphDatabaseAPI db;
    @Inject
    public NodeFunction nodeFunction;
    @Inject
    public IdFunction idFunction;
    @Inject
    public String createQuery;

    @ExtensionCallback
    protected void configuration(TestDatabaseManagementServiceBuilder builder) {
        builder.impermanent();
        builder.noOpSystemGraphInitializer();
        builder.setConfig(Settings.procedureUnrestricted(), Collections.singletonList("gds.*"));
        builder.setConfigRaw(Map.of("unsupported.dbms.debug.track_cursor_close", "true"));
        builder.setConfigRaw(Map.of("unsupported.dbms.debug.trace_cursors", "true"));
    }

    protected long clearDb() {
        AtomicLong deletedNodes = new AtomicLong();
        this.runQueryWithRowConsumer("MATCH (n) DETACH DELETE n RETURN count(n)", (Result.ResultRow row) -> deletedNodes.set(row.getNumber("count(n)").longValue()));
        return deletedNodes.get();
    }

    protected List<Node> allNodes() {
        ArrayList<Node> sourceNodes = new ArrayList<Node>();
        this.runQueryWithRowConsumer("MATCH (n) RETURN n", (Result.ResultRow row) -> sourceNodes.add(row.getNode("n")));
        return sourceNodes;
    }

    protected List<Node> allNodesWithLabel(String label) {
        ArrayList<Node> sourceNodes = new ArrayList<Node>();
        this.runQueryWithRowConsumer(StringFormatting.formatWithLocale((String)"MATCH (n:%s) RETURN n", (Object[])new Object[]{label}), (Result.ResultRow row) -> sourceNodes.add(row.getNode("n")));
        return sourceNodes;
    }

    protected void runQueryWithRowConsumer(@Language(value="Cypher") String query, Consumer<Result.ResultRow> check) {
        QueryRunner.runQueryWithRowConsumer((GraphDatabaseService)this.db, query, check);
    }

    protected void runQueryWithRowConsumer(@Language(value="Cypher") String query, BiConsumer<Transaction, Result.ResultRow> check) {
        QueryRunner.runQueryWithRowConsumer((GraphDatabaseService)this.db, query, Collections.emptyMap(), check);
    }

    protected void runQueryWithRowConsumer(@Language(value="Cypher") String query, Map<String, Object> params, Consumer<Result.ResultRow> check) {
        QueryRunner.runQueryWithRowConsumer((GraphDatabaseService)this.db, query, params, BaseTest.discardTx(check));
    }

    protected void runQueryWithRowConsumer(GraphDatabaseService localDb, @Language(value="Cypher") String query, Map<String, Object> params, Consumer<Result.ResultRow> check) {
        QueryRunner.runQueryWithRowConsumer(localDb, query, params, BaseTest.discardTx(check));
    }

    protected void runQueryWithRowConsumer(GraphDatabaseService localDb, @Language(value="Cypher") String query, Consumer<Result.ResultRow> check) {
        QueryRunner.runQueryWithRowConsumer(localDb, query, Collections.emptyMap(), BaseTest.discardTx(check));
    }

    protected void runQueryWithRowConsumer(String username, @Language(value="Cypher") String query, Consumer<Result.ResultRow> check) {
        QueryRunner.runQueryWithRowConsumer((GraphDatabaseService)this.db, username, query, Collections.emptyMap(), BaseTest.discardTx(check));
    }

    protected <T> T runQuery(String username, @Language(value="Cypher") String query, Function<Result, T> resultFunction) {
        return QueryRunner.runQuery((GraphDatabaseService)this.db, username, query, Collections.emptyMap(), resultFunction);
    }

    protected void runQuery(String username, @Language(value="Cypher") String query, Map<String, Object> params) {
        QueryRunner.runQuery((GraphDatabaseService)this.db, username, query, params);
    }

    protected void runQuery(String username, @Language(value="Cypher") String query) {
        this.runQuery(username, query, Map.of());
    }

    protected void runQuery(GraphDatabaseService db, @Language(value="Cypher") String query, Map<String, Object> params) {
        QueryRunner.runQuery(db, query, params);
    }

    protected void runQuery(@Language(value="Cypher") String query) {
        QueryRunner.runQuery((GraphDatabaseService)this.db, query);
    }

    protected void runQuery(@Language(value="Cypher") String query, Map<String, Object> params) {
        QueryRunner.runQuery((GraphDatabaseService)this.db, query, params);
    }

    protected <T> T runQuery(@Language(value="Cypher") String query, Function<Result, T> resultFunction) {
        return QueryRunner.runQuery((GraphDatabaseService)this.db, query, Collections.emptyMap(), resultFunction);
    }

    protected <T> T runQuery(@Language(value="Cypher") String query, Map<String, Object> params, Function<Result, T> resultFunction) {
        return QueryRunner.runQuery((GraphDatabaseService)this.db, query, params, resultFunction);
    }

    protected <T> T runQuery(GraphDatabaseService db, @Language(value="Cypher") String query, Map<String, Object> params, Function<Result, T> resultFunction) {
        return QueryRunner.runQuery(db, query, params, resultFunction);
    }

    protected void runQueryWithResultConsumer(@Language(value="Cypher") String query, Map<String, Object> params, Consumer<Result> check) {
        QueryRunner.runQueryWithResultConsumer((GraphDatabaseService)this.db, query, params, check);
    }

    protected void runQueryWithResultConsumer(@Language(value="Cypher") String query, Consumer<Result> check) {
        QueryRunner.runQueryWithResultConsumer((GraphDatabaseService)this.db, query, Collections.emptyMap(), check);
    }

    private static BiConsumer<Transaction, Result.ResultRow> discardTx(Consumer<Result.ResultRow> check) {
        return (tx, row) -> check.accept((Result.ResultRow)row);
    }

    protected void assertCypherResult(@Language(value="Cypher") String query, List<Map<String, Object>> expected) {
        this.assertCypherResult(query, Collections.emptyMap(), expected);
    }

    protected void assertCypherResult(@Language(value="Cypher") String query, Map<String, Object> queryParameters, List<Map<String, Object>> expected) {
        TestSupport.assertCypherResult((GraphDatabaseService)this.db, query, queryParameters, expected);
    }

    static {
        Assertions.setExtractBareNamePropertyMethods((boolean)true);
    }
}

