/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.immutables.value.Generated;
import org.neo4j.gds.GdsCypher;

@Generated(from="GdsCypher.call", generator="Immutables")
final class CallBuilder {
    private static final long INIT_BIT_ALGO_NAME = 1L;
    private static final long INIT_BIT_EXECUTION_MODE = 2L;
    private static final long INIT_BIT_GRAPH_NAME = 4L;
    private long initBits = 7L;
    private List<String> algoNamespace = new ArrayList<String>();
    private String algoName;
    private GdsCypher.ExecutionMode executionMode;
    private GdsCypher.SpecialExecution specialExecution;
    private String graphName;
    private Map<String, Object> parameters = new LinkedHashMap<String, Object>();
    private List<String> yields = new ArrayList<String>();

    CallBuilder() {
        this.specialExecution(GdsCypher.SpecialExecution.NORMAL);
    }

    public final CallBuilder addAlgoNamespace(String element) {
        this.algoNamespace.add(Objects.requireNonNull(element, "algoNamespace element"));
        return this;
    }

    public final CallBuilder addAlgoNamespace(String ... elements) {
        for (String element : elements) {
            this.algoNamespace.add(Objects.requireNonNull(element, "algoNamespace element"));
        }
        return this;
    }

    public final CallBuilder algoNamespace(Iterable<String> elements) {
        this.algoNamespace.clear();
        return this.addAllAlgoNamespace(elements);
    }

    public final CallBuilder addAllAlgoNamespace(Iterable<String> elements) {
        for (String element : elements) {
            this.algoNamespace.add(Objects.requireNonNull(element, "algoNamespace element"));
        }
        return this;
    }

    public final CallBuilder algoName(String algoName) {
        this.algoName = Objects.requireNonNull(algoName, "algoName");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public final CallBuilder executionMode(GdsCypher.ExecutionMode executionMode) {
        this.executionMode = Objects.requireNonNull(executionMode, "executionMode");
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return this;
    }

    private final CallBuilder normalSpecialExecution() {
        return this.specialExecution(GdsCypher.SpecialExecution.NORMAL);
    }

    public final CallBuilder estimateSpecialExecution() {
        return this.specialExecution(GdsCypher.SpecialExecution.ESTIMATE);
    }

    private final CallBuilder specialExecution(GdsCypher.SpecialExecution specialExecution) {
        this.specialExecution = specialExecution;
        return this;
    }

    public final CallBuilder graphName(String graphName) {
        this.graphName = Objects.requireNonNull(graphName, "graphName");
        this.initBits &= 0xFFFFFFFFFFFFFFFBL;
        return this;
    }

    public final CallBuilder putParameter(String key, Object value) {
        this.parameters.put(Objects.requireNonNull(key, "parameters key"), Objects.requireNonNull(value, "parameters value"));
        return this;
    }

    public final CallBuilder putParameter(Map.Entry<String, ? extends Object> entry) {
        String k = entry.getKey();
        Object v = entry.getValue();
        this.parameters.put(Objects.requireNonNull(k, "parameters key"), Objects.requireNonNull(v, "parameters value"));
        return this;
    }

    public final CallBuilder parameters(Map<String, ? extends Object> entries) {
        this.parameters.clear();
        return this.putAllParameters(entries);
    }

    public final CallBuilder putAllParameters(Map<String, ? extends Object> entries) {
        for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
            String k = e.getKey();
            Object v = e.getValue();
            this.parameters.put(Objects.requireNonNull(k, "parameters key"), Objects.requireNonNull(v, "parameters value"));
        }
        return this;
    }

    public final CallBuilder addYield(String element) {
        this.yields.add(Objects.requireNonNull(element, "yields element"));
        return this;
    }

    public final CallBuilder addYields(String ... elements) {
        for (String element : elements) {
            this.yields.add(Objects.requireNonNull(element, "yields element"));
        }
        return this;
    }

    public final CallBuilder yields(Iterable<String> elements) {
        this.yields.clear();
        return this.addAllYields(elements);
    }

    public final CallBuilder addAllYields(Iterable<String> elements) {
        for (String element : elements) {
            this.yields.add(Objects.requireNonNull(element, "yields element"));
        }
        return this;
    }

    public String build() {
        this.checkRequiredAttributes();
        return GdsCypher.call(CallBuilder.createUnmodifiableList(true, this.algoNamespace), this.algoName, this.executionMode, this.specialExecution, this.graphName, CallBuilder.createUnmodifiableMap(false, false, this.parameters), CallBuilder.createUnmodifiableList(true, this.yields));
    }

    private boolean algoNameIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    private boolean executionModeIsSet() {
        return (this.initBits & 2L) == 0L;
    }

    private boolean graphNameIsSet() {
        return (this.initBits & 4L) == 0L;
    }

    private void checkRequiredAttributes() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.algoNameIsSet()) {
            attributes.add("algoName");
        }
        if (!this.executionModeIsSet()) {
            attributes.add("executionMode");
        }
        if (!this.graphNameIsSet()) {
            attributes.add("graphName");
        }
        return "Cannot build call, some of required attributes are not set " + attributes;
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    Objects.requireNonNull(v, "value");
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }
}

