/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Assertions;
import org.neo4j.gds.core.utils.paged.HugeLongArray;
import org.neo4j.gds.utils.StringFormatting;

public final class CommunityHelper {
    private CommunityHelper() {
    }

    public static void assertCommunities(HugeLongArray communityData, long[] ... communities) {
        CommunityHelper.assertCommunities(communityData.toArray(), communities);
    }

    public static void assertCommunities(long[] actual, long[] ... expected) {
        List<Long> actualList = Arrays.stream(actual).boxed().collect(Collectors.toList());
        List<List<Long>> expectedList = Arrays.stream(expected).map(a -> Arrays.stream(a).boxed().collect(Collectors.toList())).collect(Collectors.toList());
        CommunityHelper.assertCommunities(actualList, expectedList);
    }

    public static void assertCommunities(List<Long> actualCommunityData, List<List<Long>> expectedCommunities) {
        for (List<Long> community : expectedCommunities) {
            CommunityHelper.assertSameCommunity(actualCommunityData, community);
        }
        for (int i = 0; i < expectedCommunities.size(); ++i) {
            for (int j = i + 1; j < expectedCommunities.size(); ++j) {
                int expected = expectedCommunities.get(i).get(0).intValue();
                int actual = expectedCommunities.get(j).get(0).intValue();
                Assertions.assertNotEquals((Long)actualCommunityData.get(expected), (Long)actualCommunityData.get(actual), (String)StringFormatting.formatWithLocale((String)"Expected node %d to be in a different community than node %d", (Object[])new Object[]{expected, actual}));
            }
        }
    }

    public static void assertSameCommunity(HugeLongArray communities, long[] members) {
        CommunityHelper.assertSameCommunity(communities.toArray(), members);
    }

    public static void assertSameCommunity(long[] communities, long[] members) {
        List<Long> communitiesList = Arrays.stream(communities).boxed().collect(Collectors.toList());
        List<Long> membersList = Arrays.stream(members).boxed().collect(Collectors.toList());
        CommunityHelper.assertSameCommunity(communitiesList, membersList);
    }

    public static void assertSameCommunity(List<Long> communities, List<Long> members) {
        long expectedCommunity = communities.get(members.get(0).intValue());
        for (int i = 1; i < members.size(); ++i) {
            Long member = members.get(i);
            long actualCommunity = communities.get(member.intValue());
            Assertions.assertEquals((long)expectedCommunity, (long)actualCommunity, (String)StringFormatting.formatWithLocale((String)"Expected node %d (community %d) to have the same community as node %d (community %d)", (Object[])new Object[]{member, actualCommunity, members.get(0), expectedCommunity}));
        }
    }

    public static void assertCommunitiesWithLabels(HugeLongArray communityData, Map<Long, long[]> expectedCommunities) {
        CommunityHelper.assertCommunitiesWithLabels(communityData.toArray(), expectedCommunities);
    }

    public static void assertCommunitiesWithLabels(long[] communityData, Map<Long, long[]> expectedCommunities) {
        List<Long> communityDataList = Arrays.stream(communityData).boxed().collect(Collectors.toList());
        List<List<Long>> expectedCommunitiesList = expectedCommunities.values().stream().map(l -> Arrays.stream(l).boxed().collect(Collectors.toList())).collect(Collectors.toList());
        CommunityHelper.assertCommunities(communityDataList, expectedCommunitiesList);
        for (Map.Entry<Long, long[]> entry : expectedCommunities.entrySet()) {
            long[] community;
            long label = entry.getKey();
            long[] lArray = community = entry.getValue();
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                Long nodeId = lArray[i];
                Assertions.assertEquals((long)label, (long)communityData[nodeId.intValue()], (String)StringFormatting.formatWithLocale((String)"Expected node %d to be in community %d, but was %d", (Object[])new Object[]{nodeId, label, communityData[nodeId.intValue()]}));
            }
        }
    }
}

