/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.api.Assertions;
import org.neo4j.gds.api.schema.PropertySchema;

public final class CsvTestSupport {
    private CsvTestSupport() {
    }

    public static void assertCsvFiles(Path path, Iterable<String> expectedFiles) {
        for (String expectedFile : expectedFiles) {
            Assertions.assertThat((Path)path).isDirectoryContaining("glob:**/" + expectedFile);
        }
    }

    public static void assertHeaderFile(Path path, String fileName, List<String> mandatoryColumns, Map<String, ? extends PropertySchema> properties) {
        ArrayList<String> expectedContent = new ArrayList<String>(mandatoryColumns);
        properties.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> expectedContent.add((String)entry.getKey() + ":" + ((PropertySchema)entry.getValue()).valueType().csvName()));
        Assertions.assertThat((Path)path.resolve(fileName)).hasContent(String.join((CharSequence)",", expectedContent));
    }

    public static void assertDataContent(Path path, String fileName, Collection<List<String>> data) {
        List expectedContent = data.stream().map(row -> String.join((CharSequence)",", row)).collect(Collectors.toList());
        try {
            List<String> fileLines = Files.readAllLines(path.resolve(fileName), StandardCharsets.UTF_8);
            Assertions.assertThat(fileLines).containsExactlyInAnyOrderElementsOf(expectedContent);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

