/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.neo4j.gds.QueryRunner;
import org.neo4j.gds.compat.MapUtil;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.kernel.internal.GraphDatabaseAPI;

public class GOTQuery {
    private static Map<String, Object> GOT_NAMES_MAP = MapUtil.map((Object[])new Object[]{"map", MapUtil.map((Object[])new Object[]{"Aemon Targaryen (Maester Aemon)", "Aemon Targaryen (son of Maekar I)", "Arstan", "Barristan Selmy", "Garin (orphan)", "Garin (Orphan)", "Hareth (Moles Town)", "Hareth (Mole's Town)", "Jaqen Hghar", "Jaqen H'ghar", "Lommy Greenhands", "Lommy", "Rattleshirt", "Lord of Bones", "Thoros of Myr", "Thoros"})});
    private static String GOT_IMPORT_QUERY = "LOAD CSV WITH HEADERS FROM 'https://raw.githubusercontent.com/tomasonjo/neo4j-game-of-thrones/master/data/battles.csv' AS row\nMERGE (b:Battle {name: row.name})\n  ON CREATE SET b.year = toInteger(row.year),\n  b.summer = row.summer,\n  b.major_death = row.major_death,\n  b.major_capture = row.major_capture,\n  b.note = row.note,\n  b.battle_type = row.battle_type,\n  b.attacker_size = toInteger(row.attacker_size),\n  b.defender_size = toInteger(row.defender_size);\n\nLOAD CSV WITH HEADERS FROM 'https://raw.githubusercontent.com/tomasonjo/neo4j-game-of-thrones/master/data/battles.csv' AS row\n\n// there is only attacker_outcome in the data,\n// so we do a CASE statement for defender_outcome\nWITH row,\n     CASE WHEN row.attacker_outcome = 'win' THEN 'loss'\n       ELSE 'win'\n       END AS defender_outcome\n\n// match the battle\nMATCH (b:Battle {name: row.name})\n\n// all battles have atleast one attacker so we don't have to use foreach trick\nMERGE (attacker1:House {name: row.attacker_1})\nMERGE (attacker1)-[a1:ATTACKER]->(b)\n  ON CREATE SET a1.outcome = row.attacker_outcome\n\n// When we want to skip null values we can use foreach trick\nFOREACH\n(ignoreMe IN CASE WHEN row.defender_1 IS NOT NULL THEN [1]\n  ELSE []\n  END |\n  MERGE (defender1:House {name: row.defender_1})\n  MERGE (defender1)-[d1:DEFENDER]->(b)\n    ON CREATE SET d1.outcome = defender_outcome\n)\nFOREACH\n(ignoreMe IN CASE WHEN row.defender_2 IS NOT NULL THEN [1]\n  ELSE []\n  END |\n  MERGE (defender2:House {name: row.defender_2})\n  MERGE (defender2)-[d2:DEFENDER]->(b)\n    ON CREATE SET d2.outcome = defender_outcome\n)\nFOREACH\n(ignoreMe IN CASE WHEN row.attacker_2 IS NOT NULL THEN [1]\n  ELSE []\n  END |\n  MERGE (attacker2:House {name: row.attacker_2})\n  MERGE (attacker2)-[a2:ATTACKER]->(b)\n    ON CREATE SET a2.outcome = row.attacker_outcome\n)\nFOREACH\n(ignoreMe IN CASE WHEN row.attacker_3 IS NOT NULL THEN [1]\n  ELSE []\n  END |\n  MERGE (attacker2:House {name: row.attacker_3})\n  MERGE (attacker3)-[a3:ATTACKER]->(b)\n    ON CREATE SET a3.outcome = row.attacker_outcome\n)\nFOREACH\n(ignoreMe IN CASE WHEN row.attacker_4 IS NOT NULL THEN [1]\n  ELSE []\n  END |\n  MERGE (attacker4:House {name: row.attacker_4})\n  MERGE (attacker4)-[a4:ATTACKER]->(b)\n    ON CREATE SET a4.outcome = row.attacker_outcome\n);\n\nLOAD CSV WITH HEADERS FROM\n'https://raw.githubusercontent.com/tomasonjo/neo4j-game-of-thrones/master/data/battles.csv'\nAS row\nMATCH (b:Battle {name: row.name})\n\n// We use coalesce, so that null values are replaced with \"Unknown\"\nMERGE (location:Location {name: coalesce(row.location, 'Unknown')})\nMERGE (b)-[:IS_IN]->(location)\nMERGE (region:Region {name: row.region})\nMERGE (location)-[:IS_IN]->(region);\n\nLOAD CSV WITH HEADERS FROM 'https://raw.githubusercontent.com/tomasonjo/neo4j-game-of-thrones/master/data/battles.csv' AS row\n\n// We split the columns that may contain more than one person\nWITH row,\n     split(row.attacker_commander, ',') AS att_commanders,\n     split(row.defender_commander, ',') AS def_commanders,\n     split(row.attacker_king, '/') AS att_kings,\n     split(row.defender_king, '/') AS def_kings,\n     row.attacker_outcome AS att_outcome,\n     CASE WHEN row.attacker_outcome = 'win' THEN 'loss'\n       ELSE 'win'\n       END AS def_outcome\nMATCH (b:Battle {name: row.name})\n\n// we unwind a list\nUNWIND att_commanders AS att_commander\nMERGE (p:Person {name: trim(att_commander)})\nMERGE (p)-[ac:ATTACKER_COMMANDER]->(b)\n  ON CREATE SET ac.outcome = att_outcome\n\n// to end the unwind and correct cardinality(number of rows)\n// we use any aggregation function ( e.g. count(*))\nWITH b, def_commanders, def_kings, att_kings, att_outcome, def_outcome,\n     COUNT(*) AS c1\nUNWIND def_commanders AS def_commander\nMERGE (p:Person {name: trim(def_commander)})\nMERGE (p)-[dc:DEFENDER_COMMANDER]->(b)\n  ON CREATE SET dc.outcome = def_outcome\n\n// reset cardinality with an aggregation function (end the unwind)\nWITH b, def_kings, att_kings, att_outcome, def_outcome, COUNT(*) AS c2\nUNWIND def_kings AS def_king\nMERGE (p:Person {name: trim(def_king)})\nMERGE (p)-[dk:DEFENDER_KING]->(b)\n  ON CREATE SET dk.outcome = def_outcome\n\n// reset cardinality with an aggregation function (end the unwind)\nWITH b, att_kings, att_outcome, COUNT(*) AS c3\nUNWIND att_kings AS att_king\nMERGE (p:Person {name: trim(att_king)})\nMERGE (p)-[ak:ATTACKER_KING]->(b)\n  ON CREATE SET ak.outcome = att_outcome;\n\nLOAD CSV WITH HEADERS FROM\n'https://raw.githubusercontent.com/tomasonjo/neo4j-game-of-thrones/master/data/character-deaths.csv'\nAS row\n\n// we can use CASE in a WITH statement\nWITH row,\n     CASE WHEN row.Nobility = '1' THEN 'Noble'\n       ELSE 'Commoner'\n       END AS status_value\n\n// as seen above we remove \"House \" for better linking\nMERGE (house:House {name: replace(row.Allegiances, 'House ', '')})\nMERGE (person:Person {name: row.Name})\n\n// we can also use CASE statement inline\nSET person.gender = CASE WHEN row.Gender = '1' THEN 'male'\n  ELSE 'female'\n  END,\nperson.book_intro_chapter = row.`Book Intro Chapter`,\nperson.book_death_chapter = row.`Death Chapter`,\nperson.book_of_death = row.`Book of Death`,\nperson.death_year = toInteger(row.`Death Year`)\nMERGE (person)-[:BELONGS_TO]->(house)\nMERGE (status:Status {name: status_value})\nMERGE (person)-[:HAS_STATUS]->(status)\n\n// doing the foreach trick to skip null values\nFOREACH\n(ignoreMe IN CASE WHEN row.GoT = '1' THEN [1]\n  ELSE []\n  END |\n  MERGE (book1:Book {sequence: 1})\n    ON CREATE SET book1.name = 'Game of thrones'\n  MERGE (person)-[:APPEARED_IN]->(book1)\n)\nFOREACH\n(ignoreMe IN CASE WHEN row.CoK = '1' THEN [1]\n  ELSE []\n  END |\n  MERGE (book2:Book {sequence: 2})\n    ON CREATE SET book2.name = 'Clash of kings'\n  MERGE (person)-[:APPEARED_IN]->(book2)\n)\nFOREACH\n(ignoreMe IN CASE WHEN row.SoS = '1' THEN [1]\n  ELSE []\n  END |\n  MERGE (book3:Book {sequence: 3})\n    ON CREATE SET book3.name = 'Storm of swords'\n  MERGE (person)-[:APPEARED_IN]->(book3)\n)\nFOREACH\n(ignoreMe IN CASE WHEN row.FfC = '1' THEN [1]\n  ELSE []\n  END |\n  MERGE (book4:Book {sequence: 4})\n    ON CREATE SET book4.name = 'Feast for crows'\n  MERGE (person)-[:APPEARED_IN]->(book4)\n)\nFOREACH\n(ignoreMe IN CASE WHEN row.DwD = '1' THEN [1]\n  ELSE []\n  END |\n  MERGE (book5:Book {sequence: 5})\n    ON CREATE SET book5.name = 'Dance with dragons'\n  MERGE (person)-[:APPEARED_IN]->(book5)\n)\nFOREACH\n(ignoreMe IN CASE WHEN row.`Book of Death` IS NOT NULL THEN [1]\n  ELSE []\n  END |\n  MERGE (book:Book {sequence: toInteger(row.`Book of Death`)})\n  MERGE (person)-[:DIED_IN]->(book)\n);\n\nLOAD CSV WITH HEADERS FROM\n'https://raw.githubusercontent.com/tomasonjo/neo4j-game-of-thrones/master/data/character-predictions.csv'\nAS row\nMERGE (p:Person {name: row.name})\n// set properties on the person node\nSET p.title = row.title,\np.death_year = toInteger(row.DateoFdeath),\np.birth_year = toInteger(row.dateOfBirth),\np.age = toInteger(row.age),\np.gender = CASE WHEN row.male = '1' THEN 'male'\n  ELSE 'female'\n  END\n\n// doing the foreach trick to skip null values\nFOREACH\n(ignoreMe IN CASE WHEN row.mother IS NOT NULL THEN [1]\n  ELSE []\n  END |\n  MERGE (mother:Person {name: row.mother})\n  MERGE (p)-[:RELATED_TO {name: 'mother'}]->(mother)\n)\nFOREACH\n(ignoreMe IN CASE WHEN row.spouse IS NOT NULL THEN [1]\n  ELSE []\n  END |\n  MERGE (spouse:Person {name: row.spouse})\n  MERGE (p)-[:RELATED_TO {name: 'spouse'}]->(spouse)\n)\nFOREACH\n(ignoreMe IN CASE WHEN row.father IS NOT NULL THEN [1]\n  ELSE []\n  END |\n  MERGE (father:Person {name: row.father})\n  MERGE (p)-[:RELATED_TO {name: 'father'}]->(father)\n)\nFOREACH\n(ignoreMe IN CASE WHEN row.heir IS NOT NULL THEN [1]\n  ELSE []\n  END |\n  MERGE (heir:Person {name: row.heir})\n  MERGE (p)-[:RELATED_TO {name: 'heir'}]->(heir)\n)\n\n// we remove \"House \" from the value for better linking of data - this didn't run in the original, but I think it should now - there was a bug in the replace\nFOREACH\n(ignoreMe IN CASE WHEN row.house IS NOT NULL THEN [1]\n  ELSE []\n  END |\n  MERGE (house:House {name: replace(row.house, 'House ', '')})\n  MERGE (p)-[:BELONGS_TO]->(house)\n);\n\nLOAD CSV WITH HEADERS FROM\n'https://raw.githubusercontent.com/tomasonjo/neo4j-game-of-thrones/master/data/character-predictions.csv'\nAS row\n\n// match person\nMERGE (p:Person {name: row.name})\n\n// doing the foreach trick... we lower row.culture for better linking\nFOREACH\n(ignoreMe IN CASE WHEN row.culture IS NOT NULL THEN [1]\n  ELSE []\n  END |\n  MERGE (culture:Culture {name: toLower(row.culture)})\n  MERGE (p)-[:MEMBER_OF_CULTURE]->(culture)\n)\nFOREACH\n(ignoreMe IN CASE WHEN row.book1 = '1' THEN [1]\n  ELSE []\n  END |\n  MERGE (book:Book {sequence: 1})\n  MERGE (p)-[:APPEARED_IN]->(book)\n)\nFOREACH\n(ignoreMe IN CASE WHEN row.book2 = '1' THEN [1]\n  ELSE []\n  END |\n  MERGE (book:Book {sequence: 2})\n  MERGE (p)-[:APPEARED_IN]->(book)\n)\nFOREACH\n(ignoreMe IN CASE WHEN row.book3 = '1' THEN [1]\n  ELSE []\n  END |\n  MERGE (book:Book {sequence: 3})\n  MERGE (p)-[:APPEARED_IN]->(book)\n)\nFOREACH\n(ignoreMe IN CASE WHEN row.book4 = '1' THEN [1]\n  ELSE []\n  END |\n  MERGE (book:Book {sequence: 4})\n  MERGE (p)-[:APPEARED_IN]->(book)\n)\nFOREACH\n(ignoreMe IN CASE WHEN row.book5 = '1' THEN [1]\n  ELSE []\n  END |\n  MERGE (book:Book {sequence: 5})\n  MERGE (p)-[:APPEARED_IN]->(book)\n);\n\nLOAD CSV WITH HEADERS FROM 'https://raw.githubusercontent.com/tomasonjo/neo4j-game-of-thrones/master/data/character-predictions.csv' AS row\n\n// do CASE statements\nWITH row,\n     CASE WHEN row.isAlive = '0' THEN [1]\n       ELSE []\n       END AS dead_person,\n     CASE WHEN row.isAliveMother = '0' THEN [1]\n       ELSE []\n       END AS dead_mother,\n     CASE WHEN row.isAliveFather = '0' THEN [1]\n       ELSE []\n       END AS dead_father,\n     CASE WHEN row.isAliveHeir = '0' THEN [1]\n       ELSE []\n       END AS dead_heir,\n     CASE WHEN row.isAliveSpouse = '0' THEN [1]\n       ELSE []\n       END AS dead_spouse\n\n// MATCH all the persons\nMATCH (p:Person {name: row.name})\n\n// We use optional match so that it doesnt stop the query if not found\nOPTIONAL MATCH (mother:Person {name: row.mother})\nOPTIONAL MATCH (father:Person {name: row.father})\nOPTIONAL MATCH (heir:Person {name: row.heir})\nOPTIONAL MATCH (spouse:Spouse {name: row.spouse})\n\n// Set the label of the dead persons\nFOREACH (d IN dead_person |\n  SET p:Dead\n)\nFOREACH (d IN dead_mother |\n  SET mother:Dead\n)\nFOREACH (d IN dead_father |\n  SET father:Dead\n)\nFOREACH (d IN dead_heir |\n  SET heir:Dead\n)\nFOREACH (d IN dead_spouse |\n  SET spouse:Dead\n);\n\nMATCH (p:Person) where exists (p.death_year)\nSET p:Dead;\n\nMATCH (p:Person)-[:DEFENDER_KING|ATTACKER_KING]-()\nSET p:King;\n\nMATCH (p:Person) where toLower(p.title) contains \"king\"\nSET p:King;\n\nMATCH (p:Person) where p.title = \"Ser\"\nSET p:Knight;\n\nLOAD CSV WITH HEADERS FROM 'https://raw.githubusercontent.com/mathbeveridge/asoiaf/master/data/asoiaf-book1-edges.csv' AS row\nWITH replace(row.Source, '-', ' ') AS srcName,\n     replace(row.Target, '-', ' ') AS tgtName,\n     toInteger(row.weight) AS weight\nMERGE (src:Person {name: coalesce($map[srcName], srcName)})\nMERGE (tgt:Person {name: coalesce($map[tgtName], tgtName)})\nMERGE (src)-[i:INTERACTS {book: 1}]->(tgt)\n  ON CREATE SET i.weight = weight\n  ON MATCH SET i.weight = i.weight + weight\nMERGE (src)-[r:INTERACTS_1]->(tgt)\n  ON CREATE SET r.weight = weight, r.book = 1;\n\nLOAD CSV WITH HEADERS FROM 'https://raw.githubusercontent.com/mathbeveridge/asoiaf/master/data/asoiaf-book2-edges.csv' AS row\nWITH replace(row.Source, '-', ' ') AS srcName,\n     replace(row.Target, '-', ' ') AS tgtName,\n     toInteger(row.weight) AS weight\nMERGE (src:Person {name: coalesce($map[srcName], srcName)})\nMERGE (tgt:Person {name: coalesce($map[tgtName], tgtName)})\nMERGE (src)-[i:INTERACTS {book: 2}]->(tgt)\n  ON CREATE SET i.weight = weight\n  ON MATCH SET i.weight = i.weight + weight\nMERGE (src)-[r:INTERACTS_2]->(tgt)\n  ON CREATE SET r.weight = weight, r.book = 2;\n\nLOAD CSV WITH HEADERS FROM 'https://raw.githubusercontent.com/mathbeveridge/asoiaf/master/data/asoiaf-book3-edges.csv' AS row\nWITH replace(row.Source, '-', ' ') AS srcName,\n     replace(row.Target, '-', ' ') AS tgtName,\n     toInteger(row.weight) AS weight\nMERGE (src:Person {name: coalesce($map[srcName], srcName)})\nMERGE (tgt:Person {name: coalesce($map[tgtName], tgtName)})\nMERGE (src)-[i:INTERACTS {book: 3}]->(tgt)\n  ON CREATE SET i.weight = weight\n  ON MATCH SET i.weight = i.weight + weight\nMERGE (src)-[r:INTERACTS_3]->(tgt)\n  ON CREATE SET r.weight = weight, r.book = 3;\n\nLOAD CSV WITH HEADERS FROM 'https://raw.githubusercontent.com/mathbeveridge/asoiaf/master/data/asoiaf-book4-edges.csv' AS row\nWITH replace(row.Source, '-', ' ') AS srcName,\n     replace(row.Target, '-', ' ') AS tgtName,\n     toInteger(row.weight) AS weight\nMERGE (src:Person {name: coalesce($map[srcName], srcName)})\nMERGE (tgt:Person {name: coalesce($map[tgtName], tgtName)})\nMERGE (src)-[i:INTERACTS {book: 4}]->(tgt)\n  ON CREATE SET i.weight = weight\n  ON MATCH SET i.weight = i.weight + weight\nMERGE (src)-[r:INTERACTS_4]->(tgt)\n  ON CREATE SET r.weight = weight, r.book = 4;\n\nLOAD CSV WITH HEADERS FROM 'https://raw.githubusercontent.com/mathbeveridge/asoiaf/master/data/asoiaf-book5-edges.csv' AS row\nWITH replace(row.Source, '-', ' ') AS srcName,\n     replace(row.Target, '-', ' ') AS tgtName,\n     toInteger(row.weight) AS weight\nMERGE (src:Person {name: coalesce($map[srcName], srcName)})\nMERGE (tgt:Person {name: coalesce($map[tgtName], tgtName)})\nMERGE (src)-[i:INTERACTS {book: 5}]->(tgt)\n  ON CREATE SET i.weight = weight\n  ON MATCH SET i.weight = i.weight + weight\nMERGE (src)-[r:INTERACTS_5]->(tgt)\n  ON CREATE SET r.weight = weight, r.book = 5;";
    private static List<String> GOT_IMPORT_QUERIES = Arrays.asList(GOT_IMPORT_QUERY.split(";"));

    public static void importGot(GraphDatabaseAPI db) {
        GOT_IMPORT_QUERIES.forEach(query -> QueryRunner.runQuery((GraphDatabaseService)db, query, GOT_NAMES_MAP));
    }
}

