/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.immutables.builder.Builder;
import org.immutables.value.Value;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.cypherdsl.core.Cypher;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.ProcedureCall;
import org.neo4j.cypherdsl.core.Statement;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.renderer.Configuration;
import org.neo4j.cypherdsl.core.renderer.Renderer;
import org.neo4j.gds.AbstractNodeProjection;
import org.neo4j.gds.AbstractProjections;
import org.neo4j.gds.AbstractPropertyMappings;
import org.neo4j.gds.AbstractRelationshipProjection;
import org.neo4j.gds.CallBuilder;
import org.neo4j.gds.ElementIdentifier;
import org.neo4j.gds.ElementProjection;
import org.neo4j.gds.ImmutableMinimalObject;
import org.neo4j.gds.ImmutablePropertyMapping;
import org.neo4j.gds.InlineGraphProjectConfigBuilder;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.NodeProjection;
import org.neo4j.gds.NodeProjections;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.PropertyMapping;
import org.neo4j.gds.PropertyMappings;
import org.neo4j.gds.RelationshipProjection;
import org.neo4j.gds.RelationshipProjections;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.DefaultValue;
import org.neo4j.gds.config.GraphProjectFromStoreConfig;
import org.neo4j.gds.config.ImmutableGraphProjectFromStoreConfig;
import org.neo4j.gds.core.Aggregation;

@Value.Style(builderVisibility=Value.Style.BuilderVisibility.PACKAGE, depluralize=true, deepImmutablesDetection=true)
public abstract class GdsCypher {
    private static final Pattern PERIOD = Pattern.compile(Pattern.quote("."));
    private static final Pattern COMMA = Pattern.compile(",");

    public static QueryBuilder call(String graphName) {
        return new QueryBuilder(graphName);
    }

    @Language(value="Cypher")
    @Builder.Factory
    static String call(List<String> algoNamespace, String algoName, ExecutionMode executionMode, @Builder.Switch(defaultName="NORMAL") SpecialExecution specialExecution, String graphName, Map<String, Object> parameters, List<String> yields) {
        String[] procedureName = GdsCypher.procedureName(algoNamespace, algoName, executionMode, specialExecution);
        Expression[] queryArguments = GdsCypher.queryArguments(graphName, parameters, specialExecution == SpecialExecution.ESTIMATE);
        Optional<SymbolicName[]> yieldsFields = GdsCypher.yieldsFields(yields);
        ProcedureCall.OngoingStandaloneCallWithArguments query = (ProcedureCall.OngoingStandaloneCallWithArguments)Cypher.call((String[])procedureName).withArgs(queryArguments);
        Statement statement = yieldsFields.map(fields -> ((ProcedureCall.OngoingStandaloneCallWithReturnFields)query.yield(fields)).build()).orElseGet(() -> ((ProcedureCall.OngoingStandaloneCallWithArguments)query).build());
        Renderer cypherRenderer = Renderer.getRenderer((Configuration)Configuration.defaultConfig());
        return cypherRenderer.render(statement);
    }

    private static String[] procedureName(Collection<String> algoNamespace, String algoName, ExecutionMode executionMode, SpecialExecution specialExecution) {
        ArrayList<String> procedureName = new ArrayList<String>(algoNamespace.size());
        if (algoNamespace.isEmpty()) {
            procedureName.add("gds");
        } else {
            procedureName.addAll(algoNamespace);
        }
        procedureName.add(algoName);
        if (executionMode instanceof ExecutionModes) {
            procedureName.add(((ExecutionModes)executionMode).name().toLowerCase(Locale.ENGLISH));
        }
        if (specialExecution == SpecialExecution.ESTIMATE) {
            procedureName.add("estimate");
        }
        return procedureName.toArray(new String[0]);
    }

    private static Expression[] queryArguments(String graphName, GraphProjectFromStoreConfig config, Map<String, Object> parameters) {
        ArrayList<Object> queryArguments = new ArrayList<Object>();
        queryArguments.add(Cypher.literalOf((Object)graphName));
        LinkedHashMap<String, Object> newParameters = new LinkedHashMap<String, Object>(parameters.size());
        Optional<Object> nodeProjection = GdsCypher.toMinimalObject(config.nodeProjections()).toObject();
        Optional<Object> relationshipProjection = GdsCypher.toMinimalObject(config.relationshipProjections()).toObject();
        queryArguments.add(nodeProjection.map(GdsCypher::toExpression).orElseGet(() -> Cypher.literalOf((Object)"")));
        queryArguments.add(relationshipProjection.map(GdsCypher::toExpression).orElseGet(() -> Cypher.literalOf((Object)"")));
        GdsCypher.toMinimalObject((AbstractPropertyMappings)config.nodeProperties(), false).toObject().ifPresent(np -> newParameters.put("nodeProperties", np));
        GdsCypher.toMinimalObject((AbstractPropertyMappings)config.relationshipProperties(), false).toObject().ifPresent(rp -> newParameters.put("relationshipProperties", rp));
        newParameters.putAll(parameters);
        parameters = newParameters;
        if (!parameters.isEmpty()) {
            queryArguments.add(Objects.requireNonNullElseGet(GdsCypher.toExpression(parameters), () -> Cypher.mapOf((Object[])new Object[0])));
        }
        return queryArguments.toArray(new Expression[0]);
    }

    private static Expression[] queryArguments(String graphName, Map<String, Object> parameters, boolean isEstimationMode) {
        ArrayList<Object> queryArguments = new ArrayList<Object>();
        queryArguments.add(Cypher.literalOf((Object)graphName));
        if (!parameters.isEmpty() || isEstimationMode) {
            queryArguments.add(Objects.requireNonNullElseGet(GdsCypher.toExpression(parameters), () -> Cypher.mapOf((Object[])new Object[0])));
        }
        return queryArguments.toArray(new Expression[0]);
    }

    private static Optional<SymbolicName[]> yieldsFields(Collection<String> yields) {
        if (yields.isEmpty()) {
            return Optional.empty();
        }
        SymbolicName[] yieldNames = (SymbolicName[])yields.stream().flatMap(COMMA::splitAsStream).map(String::trim).map(GdsCypher::name).toArray(SymbolicName[]::new);
        return Optional.of(yieldNames);
    }

    private static SymbolicName name(String name) {
        try {
            return Cypher.name((String)name);
        }
        catch (IllegalArgumentException e) {
            String message = String.format(Locale.ENGLISH, "`%s` is not a valid Cypher name: %s", name, e.getMessage());
            throw new IllegalArgumentException(message, e);
        }
    }

    @Builder.Factory
    static GraphProjectFromStoreConfig inlineGraphProjectConfig(Optional<String> graphName, Map<NodeLabel, NodeProjection> nodeProjections, Map<RelationshipType, RelationshipProjection> relProjections, List<PropertyMapping> nodeProperties, List<PropertyMapping> relProperties) {
        if (nodeProjections.isEmpty()) {
            nodeProjections = new HashMap<NodeLabel, NodeProjection>();
            nodeProjections.put(NodeLabel.ALL_NODES, NodeProjection.all());
        }
        if (relProjections.isEmpty()) {
            relProjections = new HashMap<RelationshipType, RelationshipProjection>();
            relProjections.put(RelationshipType.ALL_RELATIONSHIPS, RelationshipProjection.all());
        }
        return ImmutableGraphProjectFromStoreConfig.builder().graphName(graphName.orElse("")).nodeProjections(NodeProjections.create(nodeProjections)).relationshipProjections(RelationshipProjections.builder().putAllProjections(relProjections).build()).nodeProperties(PropertyMappings.of(nodeProperties)).relationshipProperties(PropertyMappings.of(relProperties)).build();
    }

    @Nullable
    private static Expression toExpression(@Nullable Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Expression) {
            return (Expression)value;
        }
        if (value instanceof Iterable) {
            return GdsCypher.list((Iterable)value);
        }
        if (value instanceof Map) {
            return GdsCypher.map((Map)value);
        }
        if (value instanceof Enum) {
            value = ((Enum)value).name();
        }
        if (value instanceof Number && Double.isNaN(((Number)value).doubleValue())) {
            return Cypher.literalOf((Object)0.0).divide((Expression)Cypher.literalOf((Object)0.0));
        }
        return Cypher.literalOf((Object)value);
    }

    @Nullable
    private static Expression list(@NotNull Iterable<?> values) {
        ArrayList<Expression> list = new ArrayList<Expression>();
        for (Object value : values) {
            Expression expression = GdsCypher.toExpression(value);
            if (expression == null) continue;
            list.add(expression);
        }
        if (list.isEmpty()) {
            return null;
        }
        return Cypher.listOf((Expression[])list.toArray(new Expression[0]));
    }

    @Nullable
    private static Expression map(@NotNull Map<?, ?> values) {
        ArrayList entries = new ArrayList();
        values.forEach((key, value) -> {
            Expression expression = GdsCypher.toExpression(value);
            if (expression != null) {
                entries.add(String.valueOf(key));
                entries.add(expression);
            }
        });
        if (entries.isEmpty()) {
            return null;
        }
        return Cypher.mapOf((Object[])entries.toArray());
    }

    private static <I extends ElementIdentifier, P extends ElementProjection> MinimalObject toMinimalObject(AbstractProjections<I, P> allProjections) {
        Map projections = allProjections.projections();
        if (projections.isEmpty()) {
            return MinimalObject.empty();
        }
        if (projections.size() == 1) {
            Map.Entry entry = projections.entrySet().iterator().next();
            ElementIdentifier identifier2 = (ElementIdentifier)entry.getKey();
            ElementProjection projection2 = (ElementProjection)entry.getValue();
            if (identifier2.projectAll().equals((Object)identifier2) && GdsCypher.isAllDefault(projection2)) {
                return MinimalObject.string("*");
            }
            MinimalObject projectionObject = GdsCypher.toMinimalObject(projection2, identifier2);
            return projectionObject.map(m -> MinimalObject.map(identifier.name, m));
        }
        LinkedHashMap<String, Object> value = new LinkedHashMap<String, Object>();
        projections.forEach((identifier, projection) -> GdsCypher.toMinimalObject(projection, identifier).toObject().ifPresent(o -> value.put(identifier.name, o)));
        return MinimalObject.map(value);
    }

    private static boolean isAllDefault(ElementProjection projection) {
        AbstractRelationshipProjection rel;
        if (projection instanceof AbstractRelationshipProjection && ((rel = (AbstractRelationshipProjection)projection).orientation() != Orientation.NATURAL || rel.aggregation() != Aggregation.DEFAULT)) {
            return false;
        }
        return !projection.properties().hasMappings();
    }

    private static MinimalObject toMinimalObject(ElementProjection projection, ElementIdentifier identifier) {
        if (projection instanceof AbstractNodeProjection) {
            return GdsCypher.toMinimalObject((AbstractNodeProjection)projection, identifier);
        }
        if (projection instanceof AbstractRelationshipProjection) {
            return GdsCypher.toMinimalObject((AbstractRelationshipProjection)projection, identifier);
        }
        throw new IllegalArgumentException("Unexpected projection type: " + projection.getClass().getName());
    }

    private static MinimalObject toMinimalObject(AbstractNodeProjection projection, ElementIdentifier identifier) {
        MinimalObject properties = GdsCypher.toMinimalObject((AbstractPropertyMappings)projection.properties(), false);
        if (properties.isEmpty() && GdsCypher.matchesLabel(identifier.name, projection)) {
            return MinimalObject.string(identifier.name);
        }
        LinkedHashMap<String, Object> value = new LinkedHashMap<String, Object>();
        value.put("label", projection.label());
        properties.toObject().ifPresent(o -> value.put("properties", o));
        return MinimalObject.map(value);
    }

    private static boolean matchesLabel(String label, AbstractNodeProjection projection) {
        return Objects.equals(projection.label(), label);
    }

    private static MinimalObject toMinimalObject(AbstractRelationshipProjection projection, ElementIdentifier identifier) {
        MinimalObject properties = GdsCypher.toMinimalObject((AbstractPropertyMappings)projection.properties(), true);
        if (properties.isEmpty() && GdsCypher.matchesType(identifier.name, projection)) {
            return MinimalObject.string(identifier.name);
        }
        LinkedHashMap<String, Object> value = new LinkedHashMap<String, Object>();
        value.put("type", projection.type());
        if (projection.orientation() != Orientation.NATURAL) {
            value.put("orientation", projection.orientation().name());
        }
        if (projection.aggregation() != Aggregation.DEFAULT) {
            value.put("aggregation", projection.aggregation().name());
        }
        properties.toObject().ifPresent(o -> value.put("properties", o));
        return MinimalObject.map(value);
    }

    private static boolean matchesType(String type, AbstractRelationshipProjection projection) {
        return projection.orientation() == Orientation.NATURAL && projection.aggregation() == Aggregation.DEFAULT && projection.type().equals(type);
    }

    private static MinimalObject toMinimalObject(AbstractPropertyMappings propertyMappings, boolean includeAggregation) {
        List mappings = propertyMappings.mappings();
        if (mappings.isEmpty()) {
            return MinimalObject.empty();
        }
        if (mappings.size() == 1) {
            return GdsCypher.toMinimalObject((PropertyMapping)mappings.get(0), includeAggregation, true);
        }
        LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
        for (PropertyMapping mapping : mappings) {
            GdsCypher.toMinimalObject(mapping, includeAggregation, false).map().ifPresent(properties::putAll);
        }
        return MinimalObject.map(properties);
    }

    private static MinimalObject toMinimalObject(PropertyMapping propertyMapping, boolean includeAggregation, boolean allowStringShortcut) {
        String propertyKey = propertyMapping.propertyKey();
        String neoPropertyKey = propertyMapping.neoPropertyKey();
        if (propertyKey == null || neoPropertyKey == null) {
            return MinimalObject.empty();
        }
        LinkedHashMap<String, Object> value = new LinkedHashMap<String, Object>();
        value.put("property", neoPropertyKey);
        Object defaultValue = propertyMapping.defaultValue().getObject();
        if (defaultValue != null) {
            value.put("defaultValue", defaultValue);
        }
        Aggregation aggregation = propertyMapping.aggregation();
        if (includeAggregation && aggregation != Aggregation.DEFAULT) {
            value.put("aggregation", aggregation.name());
        }
        if (allowStringShortcut && value.size() == 1 && propertyKey.equals(propertyMapping.neoPropertyKey())) {
            return MinimalObject.string(propertyKey);
        }
        return MinimalObject.map(propertyKey, value);
    }

    @ValueClass
    @Value.Immutable(singleton=true)
    static interface MinimalObject {
        public Optional<String> string();

        public Optional<Map<String, Object>> map();

        default public boolean isEmpty() {
            return this.string().isEmpty() && this.map().isEmpty();
        }

        default public MinimalObject map(Function<String, MinimalObject> string, Function<Map<String, Object>, MinimalObject> map) {
            return this.fold(string, map).orElse(MinimalObject.empty());
        }

        default public MinimalObject map(Function<Map<String, Object>, MinimalObject> map) {
            return this.fold(MinimalObject::string, map).orElse(MinimalObject.empty());
        }

        default public Optional<Object> toObject() {
            return this.fold(s -> s, m -> m);
        }

        default public <R> Optional<R> fold(Function<String, R> string, Function<Map<String, Object>, R> map) {
            if (this.string().isPresent()) {
                return Optional.of(string.apply(this.string().get()));
            }
            if (this.map().isPresent()) {
                return Optional.of(map.apply(this.map().get()));
            }
            return Optional.empty();
        }

        @Value.Check
        default public void validate() {
            if (this.string().isPresent() && this.map().isPresent()) {
                throw new IllegalStateException("Cannot be both string and map");
            }
        }

        public static MinimalObject string(String value) {
            return ImmutableMinimalObject.builder().string(value).build();
        }

        public static MinimalObject map(Map<String, Object> value) {
            if (value.isEmpty()) {
                return MinimalObject.empty();
            }
            return ImmutableMinimalObject.builder().map(value).build();
        }

        public static MinimalObject map(String key, Object value) {
            return MinimalObject.map(Map.of(key, value));
        }

        public static MinimalObject empty() {
            return ImmutableMinimalObject.of();
        }
    }

    private static final class AlgoBuilder
    implements ModeBuildStage,
    ParametersBuildStage {
        private final CallBuilder builder = new CallBuilder();

        private AlgoBuilder(String graphName, Iterable<String> namespace, String algoName) {
            this.builder.graphName(graphName);
            this.builder.algoName(algoName);
            this.builder.addAllAlgoNamespace(namespace);
        }

        @Override
        public AlgoBuilder executionMode(ExecutionMode mode) {
            this.builder.executionMode(mode);
            return this;
        }

        @Override
        public AlgoBuilder estimationMode(ExecutionMode mode) {
            this.builder.executionMode(mode).estimateSpecialExecution();
            return this;
        }

        @Override
        public AlgoBuilder addParameter(String key, Object value) {
            this.builder.putParameter(key, value);
            return this;
        }

        @Override
        public AlgoBuilder addPlaceholder(String key, String placeholder) {
            this.builder.putParameter(key, Cypher.parameter((String)placeholder));
            return this;
        }

        @Override
        public AlgoBuilder addVariable(String key, String variable) {
            this.builder.putParameter(key, GdsCypher.name(variable));
            return this;
        }

        @Override
        public AlgoBuilder addParameter(Map.Entry<String, ?> entry) {
            this.builder.putParameter(entry);
            return this;
        }

        @Override
        public AlgoBuilder addAllParameters(Map<String, ?> entries) {
            this.builder.putAllParameters(entries);
            return this;
        }

        @Override
        @Language(value="Cypher")
        public String yields(Iterable<String> elements) {
            this.builder.yields(elements);
            return this.build();
        }

        @Language(value="Cypher")
        private String build() {
            return this.builder.build();
        }
    }

    public static final class GraphProjectBuilder {
        private final String graphName;
        private final InlineGraphProjectConfigBuilder graphProjectConfigBuilder;
        private final Map<String, Object> parameters;

        private GraphProjectBuilder(String graphName) {
            this.graphName = graphName;
            this.graphProjectConfigBuilder = new InlineGraphProjectConfigBuilder().graphName(graphName);
            this.parameters = new LinkedHashMap<String, Object>();
        }

        public GraphProjectBuilder withGraphProjectConfig(GraphProjectFromStoreConfig config) {
            this.graphProjectConfigBuilder.graphName(config.graphName()).nodeProjections(config.nodeProjections().projections()).relProjections(config.relationshipProjections().projections()).nodeProperties((Iterable<? extends PropertyMapping>)config.nodeProperties()).relProperties((Iterable<? extends PropertyMapping>)config.relationshipProperties());
            return this;
        }

        public GraphProjectBuilder loadEverything() {
            return this.loadEverything(Orientation.NATURAL);
        }

        public GraphProjectBuilder loadEverything(Orientation orientation) {
            return this.withNodeLabel(NodeLabel.ALL_NODES.name, NodeProjection.all()).withRelationshipType(RelationshipType.ALL_RELATIONSHIPS.name(), RelationshipProjection.all().withOrientation(orientation));
        }

        public GraphProjectBuilder withAnyLabel() {
            return this.withNodeLabel(NodeLabel.ALL_NODES.name, NodeProjection.all());
        }

        public GraphProjectBuilder withNodeLabel(String label) {
            return this.withNodeLabels(label);
        }

        public GraphProjectBuilder withNodeLabel(String label, NodeProjection nodeProjection) {
            return this.withNodeLabels(Map.of(label, nodeProjection));
        }

        public GraphProjectBuilder withNodeLabels(String ... labels) {
            return this.withNodeLabels(Arrays.stream(labels).collect(Collectors.toMap(Function.identity(), label -> NodeProjection.builder().label(label).build())));
        }

        public GraphProjectBuilder withNodeLabels(Map<String, NodeProjection> nodeProjections) {
            nodeProjections.forEach((label, nodeProjection) -> this.graphProjectConfigBuilder.putNodeProjection(NodeLabel.of((String)label), (NodeProjection)nodeProjection));
            return this;
        }

        public GraphProjectBuilder withAnyRelationshipType() {
            return this.withRelationshipType(RelationshipType.ALL_RELATIONSHIPS.name(), RelationshipProjection.all());
        }

        public GraphProjectBuilder withRelationshipType(String type) {
            return this.withRelationshipType(type, RelationshipProjection.builder().type(type).build());
        }

        public GraphProjectBuilder withRelationshipType(String type, Orientation orientation) {
            return this.withRelationshipType(type, RelationshipProjection.builder().type(type).orientation(orientation).build());
        }

        public GraphProjectBuilder withRelationshipType(String type, String neoType) {
            return this.withRelationshipType(type, RelationshipProjection.builder().type(neoType).build());
        }

        public GraphProjectBuilder withRelationshipType(String type, RelationshipProjection relationshipProjection) {
            this.graphProjectConfigBuilder.putRelProjection(RelationshipType.of((String)type), relationshipProjection);
            return this;
        }

        public GraphProjectBuilder withNodeProperty(String nodeProperty) {
            return this.withNodeProperty(ImmutablePropertyMapping.builder().propertyKey(nodeProperty).build());
        }

        public GraphProjectBuilder withNodeProperty(String propertyKey, String neoPropertyKey) {
            return this.withNodeProperty(ImmutablePropertyMapping.builder().propertyKey(propertyKey).neoPropertyKey(neoPropertyKey).build());
        }

        public GraphProjectBuilder withNodeProperty(String neoPropertyKey, DefaultValue defaultValue) {
            return this.withNodeProperty(PropertyMapping.of((String)neoPropertyKey, (Object)defaultValue));
        }

        public GraphProjectBuilder withNodeProperty(String propertyKey, String neoPropertyKey, DefaultValue defaultValue) {
            return this.withNodeProperty(PropertyMapping.of((String)propertyKey, (String)neoPropertyKey, (Object)defaultValue));
        }

        public GraphProjectBuilder withNodeProperty(String propertyKey, DefaultValue defaultValue, Aggregation aggregation) {
            return this.withNodeProperty(PropertyMapping.of((String)propertyKey, (DefaultValue)defaultValue, (Aggregation)aggregation));
        }

        public GraphProjectBuilder withNodeProperty(String propertyKey, Aggregation aggregation) {
            return this.withNodeProperty(PropertyMapping.of((String)propertyKey, (Aggregation)aggregation));
        }

        public GraphProjectBuilder withNodeProperty(String propertyKey, String neoPropertyKey, DefaultValue defaultValue, Aggregation aggregation) {
            return this.withNodeProperty(PropertyMapping.of((String)propertyKey, (String)neoPropertyKey, (DefaultValue)defaultValue, (Aggregation)aggregation));
        }

        public GraphProjectBuilder withNodeProperty(PropertyMapping propertyMapping) {
            this.graphProjectConfigBuilder.addNodeProperty(propertyMapping);
            return this;
        }

        public GraphProjectBuilder withNodeProperties(Iterable<String> properties, DefaultValue defaultValue) {
            properties.forEach(property -> this.withNodeProperty((String)property, defaultValue));
            return this;
        }

        public GraphProjectBuilder withRelationshipProperty(String relationshipProperty) {
            return this.withRelationshipProperty(ImmutablePropertyMapping.builder().propertyKey(relationshipProperty).build());
        }

        public GraphProjectBuilder withRelationshipProperty(String propertyKey, String neoPropertyKey) {
            return this.withRelationshipProperty(ImmutablePropertyMapping.builder().propertyKey(propertyKey).neoPropertyKey(neoPropertyKey).build());
        }

        public GraphProjectBuilder withRelationshipProperty(String neoPropertyKey, DefaultValue defaultValue) {
            return this.withRelationshipProperty(PropertyMapping.of((String)neoPropertyKey, (Object)defaultValue));
        }

        public GraphProjectBuilder withRelationshipProperty(String propertyKey, String neoPropertyKey, DefaultValue defaultValue) {
            return this.withRelationshipProperty(PropertyMapping.of((String)propertyKey, (String)neoPropertyKey, (Object)defaultValue));
        }

        public GraphProjectBuilder withRelationshipProperty(String propertyKey, DefaultValue defaultValue, Aggregation aggregation) {
            return this.withRelationshipProperty(PropertyMapping.of((String)propertyKey, (DefaultValue)defaultValue, (Aggregation)aggregation));
        }

        public GraphProjectBuilder withRelationshipProperty(String propertyKey, Aggregation aggregation) {
            return this.withRelationshipProperty(PropertyMapping.of((String)propertyKey, (Aggregation)aggregation));
        }

        public GraphProjectBuilder withRelationshipProperty(String propertyKey, String neoPropertyKey, DefaultValue defaultValue, Aggregation aggregation) {
            return this.withRelationshipProperty(PropertyMapping.of((String)propertyKey, (String)neoPropertyKey, (DefaultValue)defaultValue, (Aggregation)aggregation));
        }

        public GraphProjectBuilder withRelationshipProperty(PropertyMapping propertyMapping) {
            this.graphProjectConfigBuilder.addRelProperty(propertyMapping);
            return this;
        }

        public GraphProjectBuilder addParameter(String key, Object value) {
            this.parameters.put(key, value);
            return this;
        }

        @Language(value="Cypher")
        public String yields(String ... elements) {
            return this.yields(Arrays.asList(elements));
        }

        @Language(value="Cypher")
        public String yields(Collection<String> elements) {
            String procedureName = "gds.graph.project";
            Expression[] queryArguments = GdsCypher.queryArguments(this.graphName, this.graphProjectConfigBuilder.build(), this.parameters);
            Optional<SymbolicName[]> yieldsFields = GdsCypher.yieldsFields(elements);
            ProcedureCall.OngoingStandaloneCallWithArguments query = (ProcedureCall.OngoingStandaloneCallWithArguments)Cypher.call((String)procedureName).withArgs(queryArguments);
            Statement statement = yieldsFields.map(fields -> ((ProcedureCall.OngoingStandaloneCallWithReturnFields)query.yield(fields)).build()).orElseGet(() -> ((ProcedureCall.OngoingStandaloneCallWithArguments)query).build());
            Renderer cypherRenderer = Renderer.getRenderer((Configuration)Configuration.defaultConfig());
            return cypherRenderer.render(statement);
        }
    }

    static enum SpecialExecution {
        NORMAL,
        ESTIMATE;

    }

    public static interface ParametersBuildStage {
        public ParametersBuildStage addParameter(String var1, Object var2);

        public ParametersBuildStage addParameter(Map.Entry<String, ?> var1);

        public ParametersBuildStage addPlaceholder(String var1, String var2);

        public ParametersBuildStage addVariable(String var1, String var2);

        public ParametersBuildStage addAllParameters(Map<String, ?> var1);

        @Language(value="Cypher")
        default public String yields(String ... elements) {
            return this.yields(Arrays.asList(elements));
        }

        @Language(value="Cypher")
        public String yields(Iterable<String> var1);
    }

    public static interface ModeBuildStage {
        public ParametersBuildStage executionMode(ExecutionMode var1);

        public ParametersBuildStage estimationMode(ExecutionMode var1);

        default public ParametersBuildStage writeMode() {
            return this.executionMode(ExecutionModes.WRITE);
        }

        default public ParametersBuildStage mutateMode() {
            return this.executionMode(ExecutionModes.MUTATE);
        }

        default public ParametersBuildStage statsMode() {
            return this.executionMode(ExecutionModes.STATS);
        }

        default public ParametersBuildStage streamMode() {
            return this.executionMode(ExecutionModes.STREAM);
        }

        default public ParametersBuildStage trainMode() {
            return this.executionMode(ExecutionModes.TRAIN);
        }

        default public ParametersBuildStage writeEstimation() {
            return this.estimationMode(ExecutionModes.WRITE);
        }

        default public ParametersBuildStage mutateEstimation() {
            return this.estimationMode(ExecutionModes.MUTATE);
        }

        default public ParametersBuildStage statsEstimation() {
            return this.estimationMode(ExecutionModes.STATS);
        }

        default public ParametersBuildStage streamEstimation() {
            return this.estimationMode(ExecutionModes.STREAM);
        }

        default public ParametersBuildStage trainEstimation() {
            return this.estimationMode(ExecutionModes.TRAIN);
        }
    }

    public static final class QueryBuilder {
        private final String graphName;

        private QueryBuilder(String graphName) {
            this.graphName = graphName;
        }

        public GraphProjectBuilder graphProject() {
            return new GraphProjectBuilder(this.graphName);
        }

        public ModeBuildStage algo(Iterable<String> namespace, String algoName) {
            return new AlgoBuilder(this.graphName, namespace, algoName);
        }

        public ModeBuildStage algo(String algoName) {
            Objects.requireNonNull(algoName, "algoName");
            List<String> nameParts = PERIOD.splitAsStream(algoName).collect(Collectors.toList());
            if (nameParts.isEmpty()) {
                return this.algo(Collections.emptyList(), "");
            }
            String actualAlgoName = (String)nameParts.remove(nameParts.size() - 1);
            return this.algo(nameParts, actualAlgoName);
        }

        public ModeBuildStage algo(String ... namespacedAlgoName) {
            Objects.requireNonNull(namespacedAlgoName, "namespacedAlgoName");
            if (namespacedAlgoName.length == 0) {
                return this.algo(Collections.emptyList(), "");
            }
            int lastIndex = namespacedAlgoName.length - 1;
            String[] nameParts = Arrays.copyOf(namespacedAlgoName, lastIndex);
            String actualAlgoName = namespacedAlgoName[lastIndex];
            return this.algo(Arrays.asList(nameParts), actualAlgoName);
        }
    }

    public static enum ExecutionModes implements ExecutionMode
    {
        WRITE,
        STATS,
        STREAM,
        MUTATE,
        TRAIN;

    }

    static interface ExecutionMode {
    }
}

